/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataContextDelegate;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.DataRowUtils;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.access.ObjectStoreGraphDiff;
import org.apache.cayenne.access.event.SnapshotEvent;
import org.apache.cayenne.access.event.SnapshotEventListener;
import org.apache.cayenne.graph.ArcId;
import org.apache.cayenne.graph.ChildDiffLoader;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.graph.NodeCreateOperation;
import org.apache.cayenne.graph.NodeDeleteOperation;
import org.apache.cayenne.graph.NodeDiff;
import org.apache.cayenne.graph.NodePropertyChangeOperation;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

public class ObjectStore
implements Serializable,
SnapshotEventListener,
GraphManager {
    protected Map<Object, Persistent> objectMap;
    protected Map<Object, ObjectDiff> changes;
    protected Map<Object, Map<String, ObjectId>> trackedFlattenedPaths;
    int currentDiffId;
    protected transient DataRowStore dataRowCache;
    protected boolean dataRowCacheSet;
    private Collection<GraphDiff> lifecycleEventInducedChanges;
    protected DataContext context;

    public ObjectStore(DataRowStore dataRowCache, Map<Object, Persistent> objectMap) {
        this.setDataRowCache(dataRowCache);
        if (objectMap == null) {
            throw new CayenneRuntimeException("Object map is null.", new Object[0]);
        }
        this.objectMap = objectMap;
        this.changes = new HashMap<Object, ObjectDiff>();
    }

    void childContextSyncStarted() {
        this.lifecycleEventInducedChanges = new ArrayList<GraphDiff>();
    }

    void childContextSyncStopped() {
        this.lifecycleEventInducedChanges = null;
    }

    Collection<GraphDiff> getLifecycleEventInducedChanges() {
        return this.lifecycleEventInducedChanges != null ? this.lifecycleEventInducedChanges : Collections.emptyList();
    }

    void registerLifecycleEventInducedChange(GraphDiff diff) {
        if (ChildDiffLoader.isProcessingChildDiff()) {
            ChildDiffLoader.setExternalChange(Boolean.FALSE);
        } else {
            this.lifecycleEventInducedChanges.add(diff);
        }
    }

    synchronized ObjectDiff registerDiff(Object nodeId, NodeDiff diff) {
        ObjectDiff objectDiff;
        if (diff != null) {
            diff.setDiffId(++this.currentDiffId);
        }
        if ((objectDiff = this.changes.get(nodeId)) == null) {
            Persistent object = this.objectMap.get(nodeId);
            if (object == null) {
                throw new CayenneRuntimeException("No object is registered in context with Id %s", nodeId);
            }
            if (object.getPersistenceState() == 3) {
                object.setPersistenceState(4);
                if (object instanceof DataObject) {
                    DataContextDelegate delegate;
                    DataObject dataObject = (DataObject)object;
                    DataRow snapshot = this.getCachedSnapshot((ObjectId)nodeId);
                    if (snapshot != null && snapshot.getVersion() != dataObject.getSnapshotVersion() && (delegate = this.context.nonNullDelegate()).shouldMergeChanges(dataObject, snapshot)) {
                        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
                        DataRowUtils.forceMergeWithSnapshot(this.context, descriptor, dataObject, snapshot);
                        dataObject.setSnapshotVersion(snapshot.getVersion());
                        delegate.finishedMergeChanges(dataObject);
                    }
                }
            }
            objectDiff = new ObjectDiff(object);
            objectDiff.setDiffId(++this.currentDiffId);
            this.changes.put(nodeId, objectDiff);
        }
        if (diff != null) {
            objectDiff.addDiff(diff, this);
        }
        return objectDiff;
    }

    public int registeredObjectsCount() {
        return this.objectMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRowStore getDataRowCache() {
        if (this.dataRowCache == null && this.context != null && this.dataRowCacheSet) {
            ObjectStore objectStore = this;
            synchronized (objectStore) {
                DataDomain domain;
                if (this.dataRowCache == null && (domain = this.context.getParentDataDomain()) != null) {
                    this.setDataRowCache(domain.getSharedSnapshotCache());
                }
            }
        }
        return this.dataRowCache;
    }

    public void setDataRowCache(DataRowStore dataRowCache) {
        if (dataRowCache == this.dataRowCache) {
            return;
        }
        if (this.dataRowCache != null && this.dataRowCache.getEventManager() != null) {
            this.dataRowCache.getEventManager().removeListener(this, this.dataRowCache.getSnapshotEventSubject());
        }
        this.dataRowCache = dataRowCache;
        if (dataRowCache != null && dataRowCache.getEventManager() != null) {
            dataRowCache.getEventManager().addNonBlockingListener(this, "snapshotsChanged", SnapshotEvent.class, dataRowCache.getSnapshotEventSubject(), dataRowCache);
        }
        this.dataRowCacheSet = dataRowCache != null;
    }

    public synchronized void objectsUnregistered(Collection objects) {
        if (objects.isEmpty()) {
            return;
        }
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>(objects.size());
        for (Object object1 : objects) {
            Persistent object = (Persistent)object1;
            ObjectId id = object.getObjectId();
            this.objectMap.remove(id);
            this.changes.remove(id);
            if (id != null && this.trackedFlattenedPaths != null) {
                this.trackedFlattenedPaths.remove(id);
            }
            ids.add(id);
            object.setObjectContext(null);
            object.setPersistenceState(1);
        }
        if (this.getDataRowCache() != null) {
            this.getDataRowCache().processSnapshotChanges(this, Collections.emptyMap(), Collections.emptyList(), ids, Collections.emptyList());
        }
    }

    public synchronized void objectsRolledBack() {
        Iterator<Persistent> it = this.getObjectIterator();
        while (it.hasNext()) {
            Persistent object = it.next();
            int objectState = object.getPersistenceState();
            switch (objectState) {
                case 2: {
                    it.remove();
                    object.setObjectContext(null);
                    object.setObjectId(null);
                    object.setPersistenceState(1);
                    break;
                }
                case 4: 
                case 6: {
                    object.setPersistenceState(5);
                    break;
                }
            }
        }
        this.changes = new HashMap<Object, ObjectDiff>();
    }

    ObjectStoreGraphDiff getChanges() {
        return new ObjectStoreGraphDiff(this);
    }

    Map<Object, ObjectDiff> getChangesByObjectId() {
        return this.changes;
    }

    void postprocessAfterPhantomCommit() {
        for (Object id : this.changes.keySet()) {
            Persistent object = this.objectMap.get(id);
            object.setPersistenceState(3);
        }
        this.changes.clear();
    }

    public void postprocessAfterCommit(GraphDiff parentChanges) {
        for (Object id : this.changes.keySet()) {
            Persistent object = this.objectMap.get(id);
            switch (object.getPersistenceState()) {
                case 6: {
                    this.objectMap.remove(id);
                    object.setObjectContext(null);
                    object.setPersistenceState(1);
                    break;
                }
                case 2: 
                case 4: {
                    object.setPersistenceState(3);
                }
            }
        }
        if (!parentChanges.isNoop()) {
            parentChanges.apply(new GraphChangeHandler(){

                @Override
                public void arcCreated(Object nodeId, Object targetNodeId, ArcId arcId) {
                }

                @Override
                public void arcDeleted(Object nodeId, Object targetNodeId, ArcId arcId) {
                }

                @Override
                public void nodeCreated(Object nodeId) {
                }

                @Override
                public void nodeIdChanged(Object nodeId, Object newId) {
                    ObjectStore.this.processIdChange(nodeId, newId);
                }

                @Override
                public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
                }

                @Override
                public void nodeRemoved(Object nodeId) {
                }
            });
        }
        this.changes = new HashMap<Object, ObjectDiff>();
    }

    public DataRow getCachedSnapshot(ObjectId oid) {
        if (this.context != null && this.context.getChannel() != null) {
            CachedSnapshotQuery query = new CachedSnapshotQuery(oid);
            List results = this.context.getChannel().onQuery(this.context, query).firstList();
            return results.isEmpty() ? null : (DataRow)results.get(0);
        }
        return null;
    }

    public synchronized DataRow getSnapshot(ObjectId oid) {
        if (this.context != null && this.context.getChannel() != null) {
            ObjectIdQuery query = new ObjectIdQuery(oid, true, 1);
            List results = this.context.getChannel().onQuery(this.context, query).firstList();
            return results.isEmpty() ? null : (DataRow)results.get(0);
        }
        return null;
    }

    public synchronized Iterator<Persistent> getObjectIterator() {
        return this.objectMap.values().iterator();
    }

    public synchronized boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    public synchronized List<Persistent> objectsInState(int state) {
        ArrayList<Persistent> filteredObjects = new ArrayList<Persistent>();
        for (Persistent object : this.objectMap.values()) {
            if (object.getPersistenceState() != state) continue;
            filteredObjects.add(object);
        }
        return filteredObjects;
    }

    @Override
    public void snapshotsChanged(SnapshotEvent event) {
        if (event.getPostedBy() != this && event.getSource() == this.getDataRowCache()) {
            this.processSnapshotEvent(event);
        }
    }

    synchronized void processSnapshotEvent(SnapshotEvent event) {
        Collection<ObjectId> deletedIDs;
        Map<ObjectId, DataRow> modifiedDiffs = event.getModifiedDiffs();
        if (modifiedDiffs != null && !modifiedDiffs.isEmpty()) {
            for (Map.Entry<ObjectId, DataRow> entry : modifiedDiffs.entrySet()) {
                this.processUpdatedSnapshot(entry.getKey(), entry.getValue());
            }
        }
        if ((deletedIDs = event.getDeletedIds()) != null && !deletedIDs.isEmpty()) {
            for (ObjectId deletedID : deletedIDs) {
                this.processDeletedID(deletedID);
            }
        }
        this.processInvalidatedIDs(event.getInvalidatedIds());
        this.processIndirectlyModifiedIDs(event.getIndirectlyModifiedIds());
        SnapshotEventDecorator snapshotEventDecorator = new SnapshotEventDecorator(event);
        ObjectContext originatingContext = event.getPostedBy() instanceof ObjectContext ? (ObjectContext)event.getPostedBy() : null;
        this.context.fireDataChannelChanged(originatingContext, snapshotEventDecorator);
    }

    void processIdChange(Object nodeId, Object newId) {
        Map<String, ObjectId> paths;
        Persistent object = this.objectMap.remove(nodeId);
        if (object != null) {
            object.setObjectId((ObjectId)newId);
            this.objectMap.put(newId, object);
            ObjectDiff change = this.changes.remove(nodeId);
            if (change != null) {
                this.changes.put(newId, change);
            }
        }
        if (this.trackedFlattenedPaths != null && (paths = this.trackedFlattenedPaths.remove(nodeId)) != null) {
            this.trackedFlattenedPaths.put(newId, paths);
        }
    }

    void processDeletedID(ObjectId nodeId) {
        Persistent object = this.objectMap.get(nodeId);
        if (object != null) {
            DataObject dataObject = object instanceof DataObject ? (DataObject)object : null;
            switch (object.getPersistenceState()) {
                case 3: 
                case 5: 
                case 6: {
                    DataContextDelegate delegate = this.context.nonNullDelegate();
                    if (dataObject != null && !delegate.shouldProcessDelete(dataObject)) break;
                    this.objectMap.remove(nodeId);
                    this.changes.remove(nodeId);
                    object.setObjectContext(null);
                    if (dataObject == null) break;
                    delegate.finishedProcessDelete(dataObject);
                    break;
                }
                case 4: {
                    DataContextDelegate delegate = this.context.nonNullDelegate();
                    if (dataObject == null || !delegate.shouldProcessDelete(dataObject)) break;
                    object.setPersistenceState(2);
                    this.changes.remove(nodeId);
                    this.registerNode(nodeId, object);
                    this.nodeCreated(nodeId);
                    delegate.finishedProcessDelete(dataObject);
                }
            }
        }
    }

    void processInvalidatedIDs(Collection<ObjectId> invalidatedIDs) {
        if (invalidatedIDs != null && !invalidatedIDs.isEmpty()) {
            for (ObjectId oid : invalidatedIDs) {
                DataObject object = (DataObject)this.getNode(oid);
                if (object == null) continue;
                switch (object.getPersistenceState()) {
                    case 3: {
                        object.setPersistenceState(5);
                        break;
                    }
                    case 4: {
                        DataContext context = (DataContext)object.getObjectContext();
                        DataRow diff = this.getSnapshot(oid);
                        DataContextDelegate delegate = context.nonNullDelegate();
                        if (delegate.shouldMergeChanges(object, diff)) {
                            ClassDescriptor descriptor = context.getEntityResolver().getClassDescriptor(oid.getEntityName());
                            DataRowUtils.forceMergeWithSnapshot(context, descriptor, object, diff);
                            delegate.finishedMergeChanges(object);
                        }
                    }
                    case 5: {
                        break;
                    }
                }
            }
        }
    }

    void processIndirectlyModifiedIDs(Collection<ObjectId> indirectlyModifiedIDs) {
        for (ObjectId oid : indirectlyModifiedIDs) {
            DataContextDelegate delegate;
            final DataObject object = (DataObject)this.objectMap.get(oid);
            if (object == null || object.getPersistenceState() != 3 || !(delegate = this.context.nonNullDelegate()).shouldMergeChanges(object, null)) continue;
            ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(oid.getEntityName());
            descriptor.visitProperties(new PropertyVisitor(){

                @Override
                public boolean visitToMany(ToManyProperty property) {
                    property.invalidate(object);
                    return true;
                }

                @Override
                public boolean visitToOne(ToOneProperty property) {
                    if (property.getRelationship().isSourceIndependentFromTargetChange()) {
                        property.invalidate(object);
                    }
                    return true;
                }

                @Override
                public boolean visitAttribute(AttributeProperty property) {
                    return true;
                }
            });
            delegate.finishedProcessDelete(object);
        }
    }

    void processUpdatedSnapshot(ObjectId nodeId, DataRow diff) {
        int state;
        DataObject object = (DataObject)this.objectMap.get(nodeId);
        if (object != null && (state = object.getPersistenceState()) != 5) {
            DataContextDelegate delegate;
            if (state == 3) {
                DataContextDelegate delegate2 = this.context.nonNullDelegate();
                if (delegate2.shouldMergeChanges(object, diff)) {
                    ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(nodeId.getEntityName());
                    DataRow snapshot = this.getSnapshot(object.getObjectId());
                    DataRowUtils.refreshObjectWithSnapshot(descriptor, object, snapshot, true);
                    delegate2.finishedMergeChanges(object);
                }
            } else if ((state == 6 || state == 4) && (delegate = this.context.nonNullDelegate()).shouldMergeChanges(object, diff)) {
                ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(nodeId.getEntityName());
                DataRowUtils.forceMergeWithSnapshot(this.context, descriptor, object, diff);
                delegate.finishedMergeChanges(object);
            }
        }
    }

    public DataContext getContext() {
        return this.context;
    }

    public void setContext(DataContext context) {
        this.context = context;
    }

    @Override
    public synchronized Object getNode(Object nodeId) {
        return this.objectMap.get(nodeId);
    }

    final Object getNodeNoSync(Object nodeId) {
        return this.objectMap.get(nodeId);
    }

    @Override
    public synchronized Collection<Object> registeredNodes() {
        return new ArrayList<Object>(this.objectMap.values());
    }

    @Override
    public synchronized void registerNode(Object nodeId, Object nodeObject) {
        this.objectMap.put(nodeId, (Persistent)nodeObject);
    }

    @Override
    public synchronized Object unregisterNode(Object nodeId) {
        Object object = this.getNode(nodeId);
        if (object != null) {
            this.objectsUnregistered(Collections.singleton(object));
        }
        return object;
    }

    @Override
    public void nodeIdChanged(Object nodeId, Object newId) {
        throw new UnsupportedOperationException("nodeIdChanged");
    }

    @Override
    public void nodeCreated(Object nodeId) {
        NodeCreateOperation diff = new NodeCreateOperation(nodeId);
        if (this.lifecycleEventInducedChanges != null) {
            this.registerLifecycleEventInducedChange(diff);
        }
        this.registerDiff(nodeId, diff);
    }

    @Override
    public void nodeRemoved(Object nodeId) {
        NodeDeleteOperation diff = new NodeDeleteOperation(nodeId);
        if (this.lifecycleEventInducedChanges != null) {
            this.registerLifecycleEventInducedChange(diff);
        }
        this.registerDiff(nodeId, diff);
    }

    @Override
    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        if (this.lifecycleEventInducedChanges != null) {
            this.registerLifecycleEventInducedChange(new NodePropertyChangeOperation(nodeId, property, oldValue, newValue));
        }
        this.registerDiff(nodeId, null);
    }

    @Override
    public void arcCreated(Object nodeId, Object targetNodeId, ArcId arcId) {
        ObjectDiff.ArcOperation diff = new ObjectDiff.ArcOperation(nodeId, targetNodeId, arcId, false);
        if (this.lifecycleEventInducedChanges != null) {
            this.registerLifecycleEventInducedChange(diff);
        }
        this.registerDiff(nodeId, diff);
    }

    @Override
    public void arcDeleted(Object nodeId, Object targetNodeId, ArcId arcId) {
        ObjectDiff.ArcOperation diff = new ObjectDiff.ArcOperation(nodeId, targetNodeId, arcId, true);
        if (this.lifecycleEventInducedChanges != null) {
            this.registerLifecycleEventInducedChange(diff);
        }
        this.registerDiff(nodeId, diff);
    }

    boolean hasFlattenedPath(ObjectId objectId, String path) {
        if (this.trackedFlattenedPaths == null) {
            return false;
        }
        return this.trackedFlattenedPaths.getOrDefault(objectId, Collections.emptyMap()).containsKey(path);
    }

    public ObjectId getFlattenedId(ObjectId objectId, String path) {
        if (this.trackedFlattenedPaths == null) {
            return null;
        }
        return (ObjectId)this.trackedFlattenedPaths.getOrDefault(objectId, Collections.emptyMap()).get(path);
    }

    public Collection<ObjectId> getFlattenedIds(ObjectId objectId) {
        if (this.trackedFlattenedPaths == null) {
            return Collections.emptyList();
        }
        return this.trackedFlattenedPaths.getOrDefault(objectId, Collections.emptyMap()).values();
    }

    public void markFlattenedPath(ObjectId objectId, String path, ObjectId id) {
        if (this.trackedFlattenedPaths == null) {
            this.trackedFlattenedPaths = new ConcurrentHashMap<Object, Map<String, ObjectId>>();
        }
        this.trackedFlattenedPaths.computeIfAbsent(objectId, o -> new ConcurrentHashMap()).put(path, id);
    }

    class SnapshotEventDecorator
    implements GraphDiff {
        SnapshotEvent event;

        SnapshotEventDecorator(SnapshotEvent event) {
            this.event = event;
        }

        SnapshotEvent getEvent() {
            return this.event;
        }

        @Override
        public void apply(GraphChangeHandler handler) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isNoop() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void undo(GraphChangeHandler handler) {
            throw new UnsupportedOperationException();
        }
    }

    final class CachedSnapshotQuery
    extends ObjectIdQuery {
        CachedSnapshotQuery(ObjectId oid) {
            super(oid, true, 3);
        }

        void resetId(ObjectId oid) {
            this.objectId = oid;
            this.replacementQuery = null;
        }
    }
}

