/*
 * Decompiled with CFR 0.152.
 */
package one.block.eosiojava.utilities;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import one.block.eosiojava.enums.AlgorithmEmployed;
import one.block.eosiojava.error.utilities.Base58ManipulationError;
import one.block.eosiojava.error.utilities.EOSFormatterError;
import one.block.eosiojava.error.utilities.PEMProcessorError;
import one.block.eosiojava.utilities.EOSFormatter;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.math.ec.FixedPointUtil;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.jetbrains.annotations.NotNull;

public class PEMProcessor {
    private static final String PRIVATE_KEY_TYPE = "EC PRIVATE KEY";
    private static final int PRIVATE_KEY_START_INDEX = 2;
    private static final String SECP256_R1 = "secp256r1";
    private static final String SECP256_K1 = "secp256k1";
    private static final X9ECParameters CURVE_PARAMS_R1 = CustomNamedCurves.getByName((String)"secp256r1");
    private static final X9ECParameters CURVE_PARAMS_K1 = CustomNamedCurves.getByName((String)"secp256k1");
    private static final ECDomainParameters CURVE_R1;
    private static final ECDomainParameters CURVE_K1;
    private static final int BIG_INTEGER_POSITIVE = 1;
    private PemObject pemObject;
    private String pemObjectString;

    public PEMProcessor(String pemObject) throws PEMProcessorError {
        this.pemObjectString = pemObject;
        try (CharArrayReader reader = new CharArrayReader(this.pemObjectString.toCharArray());
             PemReader pemReader = new PemReader((Reader)reader);){
            this.pemObject = pemReader.readPemObject();
            if (this.pemObject == null) {
                throw new PEMProcessorError("Cannot read PEM object!");
            }
        }
        catch (Exception e) {
            throw new PEMProcessorError("Error parsing PEM object!", e);
        }
    }

    @NotNull
    public String getType() {
        return this.pemObject.getType();
    }

    @NotNull
    public String getDERFormat() {
        return Hex.toHexString((byte[])this.pemObject.getContent());
    }

    @NotNull
    public AlgorithmEmployed getAlgorithm() throws PEMProcessorError {
        String oid;
        Object pemObjectParsed = this.parsePEMObject();
        if (pemObjectParsed instanceof SubjectPublicKeyInfo) {
            oid = ((SubjectPublicKeyInfo)pemObjectParsed).getAlgorithm().getParameters().toString();
        } else if (pemObjectParsed instanceof PEMKeyPair) {
            oid = ((PEMKeyPair)pemObjectParsed).getPrivateKeyInfo().getPrivateKeyAlgorithm().getParameters().toString();
        } else {
            throw new PEMProcessorError("Error converting DER encoded key to PEM format!");
        }
        if (SECObjectIdentifiers.secp256r1.getId().equals(oid)) {
            return AlgorithmEmployed.SECP256R1;
        }
        if (SECObjectIdentifiers.secp256k1.getId().equals(oid)) {
            return AlgorithmEmployed.SECP256K1;
        }
        throw new PEMProcessorError("Unsupported algorithm!" + oid);
    }

    @NotNull
    public byte[] getKeyData() throws PEMProcessorError {
        Object pemObjectParsed = this.parsePEMObject();
        if (pemObjectParsed instanceof SubjectPublicKeyInfo) {
            return ((SubjectPublicKeyInfo)pemObjectParsed).getPublicKeyData().getBytes();
        }
        if (pemObjectParsed instanceof PEMKeyPair) {
            DLSequence sequence;
            try (ASN1InputStream asn1InputStream = new ASN1InputStream(Hex.decode((String)this.getDERFormat()));){
                sequence = (DLSequence)asn1InputStream.readObject();
            }
            catch (IOException e) {
                throw new PEMProcessorError(e);
            }
            for (Object obj : sequence) {
                if (!(obj instanceof DEROctetString)) continue;
                byte[] key = new byte[]{};
                try {
                    key = ((DEROctetString)obj).getEncoded();
                }
                catch (IOException e) {
                    throw new PEMProcessorError(e);
                }
                return Arrays.copyOfRange((byte[])key, (int)2, (int)key.length);
            }
            throw new PEMProcessorError("Key data not found in PEM object!");
        }
        throw new PEMProcessorError("Error converting DER encoded key to PEM format!");
    }

    public String extractEOSPublicKeyFromPrivateKey(boolean isLegacy) throws PEMProcessorError {
        ECPoint g;
        BigInteger n;
        if (!this.getType().equals(PRIVATE_KEY_TYPE)) {
            throw new PEMProcessorError("This is not a private key!");
        }
        AlgorithmEmployed keyCurve = this.getAlgorithm();
        BigInteger privateKeyBI = new BigInteger(1, this.getKeyData());
        switch (keyCurve) {
            case SECP256R1: {
                n = CURVE_R1.getN();
                g = CURVE_R1.getG();
                break;
            }
            default: {
                n = CURVE_K1.getN();
                g = CURVE_K1.getG();
            }
        }
        if (privateKeyBI.bitLength() > n.bitLength()) {
            privateKeyBI = privateKeyBI.mod(n);
        }
        byte[] publicKeyByteArray = new FixedPointCombMultiplier().multiply(g, privateKeyBI).getEncoded(true);
        try {
            return EOSFormatter.encodePublicKey(publicKeyByteArray, keyCurve, isLegacy);
        }
        catch (Base58ManipulationError e) {
            throw new PEMProcessorError(e);
        }
    }

    public String extractPEMPublicKeyFromPrivateKey(boolean isLegacy) throws PEMProcessorError {
        try {
            return EOSFormatter.convertEOSPublicKeyToPEMFormat(this.extractEOSPublicKeyFromPrivateKey(isLegacy));
        }
        catch (EOSFormatterError e) {
            throw new PEMProcessorError(e);
        }
    }

    public static ECDomainParameters getCurveDomainParameters(AlgorithmEmployed curve) throws PEMProcessorError {
        switch (curve) {
            case SECP256R1: 
            case PRIME256V1: {
                return CURVE_R1;
            }
            case SECP256K1: {
                return CURVE_K1;
            }
        }
        throw new PEMProcessorError("Unsupported algorithm!");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Object parsePEMObject() throws PEMProcessorError {
        try (CharArrayReader reader = new CharArrayReader(this.pemObjectString.toCharArray());){
            Object object;
            try (PEMParser pemParser = new PEMParser((Reader)reader);){
                object = pemParser.readObject();
            }
            return object;
        }
        catch (IOException e) {
            throw new PEMProcessorError("Error reading PEM object!", e);
        }
    }

    static {
        FixedPointUtil.precompute((ECPoint)CURVE_PARAMS_R1.getG());
        CURVE_R1 = new ECDomainParameters(CURVE_PARAMS_R1.getCurve(), CURVE_PARAMS_R1.getG(), CURVE_PARAMS_R1.getN(), CURVE_PARAMS_R1.getH());
        CURVE_K1 = new ECDomainParameters(CURVE_PARAMS_K1.getCurve(), CURVE_PARAMS_K1.getG(), CURVE_PARAMS_K1.getN(), CURVE_PARAMS_K1.getH());
    }
}

