/*
 * Decompiled with CFR 0.152.
 */
package one.block.eosiojava.utilities;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateFormatter {
    public static final String BACKEND_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String BACKEND_DATE_PATTERN_WITH_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss.SSS zzz";
    public static final String BACKEND_DATE_TIME_ZONE = "UTC";

    private DateFormatter() {
    }

    public static long convertBackendTimeToMilli(String backendTime) throws ParseException {
        String[] datePatterns;
        for (String datePattern : datePatterns = new String[]{BACKEND_DATE_PATTERN, BACKEND_DATE_PATTERN_WITH_TIMEZONE}) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
                sdf.setTimeZone(TimeZone.getTimeZone(BACKEND_DATE_TIME_ZONE));
                Date parsedDate = sdf.parse(backendTime);
                return parsedDate.getTime();
            }
            catch (ParseException parseException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw new ParseException("Unable to parse input backend time with supported date patterns!", 0);
    }

    public static String convertMilliSecondToBackendTimeString(long timeInMilliSeconds) {
        SimpleDateFormat sdf = new SimpleDateFormat(BACKEND_DATE_PATTERN);
        sdf.setTimeZone(TimeZone.getTimeZone(BACKEND_DATE_TIME_ZONE));
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMilliSeconds);
        return sdf.format(calendar.getTime());
    }
}

