/*
 * Decompiled with CFR 0.152.
 */
package one.block.eosiojava.utilities;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import org.bitcoinj.core.Sha256Hash;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.jetbrains.annotations.NotNull;

public class ByteFormatter {
    private static final int BASE64_PADDING = 4;
    private static final char BASE64_PADDING_CHAR = '=';
    @NotNull
    private byte[] context;

    public ByteFormatter(@NotNull byte[] context) {
        this.context = context;
    }

    public static ByteFormatter createFromBase64(@NotNull String base64String) {
        String trimmed = CharMatcher.is((char)'=').removeFrom((CharSequence)base64String);
        String padded = Strings.padEnd((String)trimmed, (int)((trimmed.length() + 4 - 1) / 4 * 4), (char)'=');
        return new ByteFormatter(Base64.decode((String)padded));
    }

    public static ByteFormatter createFromHex(@NotNull String hexString) {
        byte[] data = Hex.decode((String)hexString);
        return new ByteFormatter(data);
    }

    public String toHex() {
        return Hex.toHexString((byte[])this.context);
    }

    public ByteFormatter sha256() {
        return new ByteFormatter(Sha256Hash.hash((byte[])this.context));
    }
}

