/*
 * Decompiled with CFR 0.152.
 */
package one.block.eosiojava.session;

import one.block.eosiojava.error.session.TransactionProcessorConstructorInputError;
import one.block.eosiojava.interfaces.IABIProvider;
import one.block.eosiojava.interfaces.IRPCProvider;
import one.block.eosiojava.interfaces.ISerializationProvider;
import one.block.eosiojava.interfaces.ISignatureProvider;
import one.block.eosiojava.models.rpcProvider.Transaction;
import one.block.eosiojava.session.TransactionProcessor;
import org.jetbrains.annotations.NotNull;

public class TransactionSession {
    @NotNull
    private ISerializationProvider serializationProvider;
    @NotNull
    private IRPCProvider rpcProvider;
    @NotNull
    private IABIProvider abiProvider;
    @NotNull
    private ISignatureProvider signatureProvider;

    public TransactionSession(@NotNull ISerializationProvider serializationProvider, @NotNull IRPCProvider rpcProvider, @NotNull IABIProvider abiProvider, @NotNull ISignatureProvider signatureProvider) {
        this.serializationProvider = serializationProvider;
        this.rpcProvider = rpcProvider;
        this.abiProvider = abiProvider;
        this.signatureProvider = signatureProvider;
    }

    public TransactionProcessor getTransactionProcessor() {
        return new TransactionProcessor(this.serializationProvider, this.rpcProvider, this.abiProvider, this.signatureProvider);
    }

    public TransactionProcessor getTransactionProcessor(Transaction transaction) throws TransactionProcessorConstructorInputError {
        return new TransactionProcessor(this.serializationProvider, this.rpcProvider, this.abiProvider, this.signatureProvider, transaction);
    }

    @NotNull
    public ISerializationProvider getSerializationProvider() {
        return this.serializationProvider;
    }

    @NotNull
    public IRPCProvider getRpcProvider() {
        return this.rpcProvider;
    }

    @NotNull
    public IABIProvider getAbiProvider() {
        return this.abiProvider;
    }

    @NotNull
    public ISignatureProvider getSignatureProvider() {
        return this.signatureProvider;
    }
}

