/*
 * Decompiled with CFR 0.152.
 */
package one.block.eosiojava.session;

import com.google.common.base.Strings;
import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import one.block.eosiojava.error.abiProvider.GetAbiError;
import one.block.eosiojava.error.rpcProvider.GetBlockInfoRpcError;
import one.block.eosiojava.error.rpcProvider.GetInfoRpcError;
import one.block.eosiojava.error.rpcProvider.GetRequiredKeysRpcError;
import one.block.eosiojava.error.rpcProvider.SendTransactionRpcError;
import one.block.eosiojava.error.serializationProvider.DeserializeTransactionError;
import one.block.eosiojava.error.serializationProvider.SerializeError;
import one.block.eosiojava.error.serializationProvider.SerializePackedTransactionError;
import one.block.eosiojava.error.serializationProvider.SerializeTransactionError;
import one.block.eosiojava.error.session.TransactionBroadCastEmptySignatureError;
import one.block.eosiojava.error.session.TransactionBroadCastError;
import one.block.eosiojava.error.session.TransactionCreateSignatureRequestAbiError;
import one.block.eosiojava.error.session.TransactionCreateSignatureRequestEmptyAvailableKeyError;
import one.block.eosiojava.error.session.TransactionCreateSignatureRequestError;
import one.block.eosiojava.error.session.TransactionCreateSignatureRequestKeyError;
import one.block.eosiojava.error.session.TransactionCreateSignatureRequestRequiredKeysEmptyError;
import one.block.eosiojava.error.session.TransactionCreateSignatureRequestRpcError;
import one.block.eosiojava.error.session.TransactionCreateSignatureRequestSerializationError;
import one.block.eosiojava.error.session.TransactionGetSignatureDeserializationError;
import one.block.eosiojava.error.session.TransactionGetSignatureError;
import one.block.eosiojava.error.session.TransactionGetSignatureNotAllowModifyTransactionError;
import one.block.eosiojava.error.session.TransactionGetSignatureSigningError;
import one.block.eosiojava.error.session.TransactionPrepareError;
import one.block.eosiojava.error.session.TransactionPrepareInputError;
import one.block.eosiojava.error.session.TransactionPrepareRpcError;
import one.block.eosiojava.error.session.TransactionProcessorConstructorInputError;
import one.block.eosiojava.error.session.TransactionSendTransactionError;
import one.block.eosiojava.error.session.TransactionSerializeError;
import one.block.eosiojava.error.session.TransactionSignAndBroadCastError;
import one.block.eosiojava.error.session.TransactionSignError;
import one.block.eosiojava.error.signatureProvider.GetAvailableKeysError;
import one.block.eosiojava.error.signatureProvider.SignatureProviderError;
import one.block.eosiojava.interfaces.IABIProvider;
import one.block.eosiojava.interfaces.IRPCProvider;
import one.block.eosiojava.interfaces.ISerializationProvider;
import one.block.eosiojava.interfaces.ISignatureProvider;
import one.block.eosiojava.models.AbiEosSerializationObject;
import one.block.eosiojava.models.EOSIOName;
import one.block.eosiojava.models.rpcProvider.Action;
import one.block.eosiojava.models.rpcProvider.ContextFreeData;
import one.block.eosiojava.models.rpcProvider.Transaction;
import one.block.eosiojava.models.rpcProvider.TransactionConfig;
import one.block.eosiojava.models.rpcProvider.request.GetBlockInfoRequest;
import one.block.eosiojava.models.rpcProvider.request.GetRequiredKeysRequest;
import one.block.eosiojava.models.rpcProvider.request.SendTransactionRequest;
import one.block.eosiojava.models.rpcProvider.response.GetBlockInfoResponse;
import one.block.eosiojava.models.rpcProvider.response.GetInfoResponse;
import one.block.eosiojava.models.rpcProvider.response.GetRequiredKeysResponse;
import one.block.eosiojava.models.rpcProvider.response.SendTransactionResponse;
import one.block.eosiojava.models.signatureProvider.EosioTransactionSignatureRequest;
import one.block.eosiojava.models.signatureProvider.EosioTransactionSignatureResponse;
import one.block.eosiojava.utilities.DateFormatter;
import one.block.eosiojava.utilities.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransactionProcessor {
    @NotNull
    private ISerializationProvider serializationProvider;
    @NotNull
    private IRPCProvider rpcProvider;
    @NotNull
    private IABIProvider abiProvider;
    @NotNull
    private ISignatureProvider signatureProvider;
    @Nullable
    private Transaction transaction;
    @Nullable
    private Transaction originalTransaction;
    @NotNull
    private ContextFreeData contextFreeData;
    @NotNull
    private List<String> signatures = new ArrayList<String>();
    @Nullable
    private String serializedTransaction;
    @Nullable
    private List<String> availableKeys;
    @Nullable
    private List<String> requiredKeys;
    @NotNull
    private TransactionConfig transactionConfig = new TransactionConfig();
    @Nullable
    private String chainId;
    private boolean isTransactionModificationAllowed;
    private static final String PACKED_TRANSACTION_V0_PREFIX = "00";

    public TransactionProcessor(@NotNull ISerializationProvider serializationProvider, @NotNull IRPCProvider rpcProvider, @NotNull IABIProvider abiProvider, @NotNull ISignatureProvider signatureProvider) {
        this.serializationProvider = serializationProvider;
        this.rpcProvider = rpcProvider;
        this.abiProvider = abiProvider;
        this.signatureProvider = signatureProvider;
    }

    public TransactionProcessor(@NotNull ISerializationProvider serializationProvider, @NotNull IRPCProvider rpcProvider, @NotNull IABIProvider abiProvider, @NotNull ISignatureProvider signatureProvider, @NotNull Transaction transaction) throws TransactionProcessorConstructorInputError {
        this(serializationProvider, rpcProvider, abiProvider, signatureProvider);
        this.transaction = transaction;
        if (this.transaction.getActions().isEmpty()) {
            throw new TransactionProcessorConstructorInputError("Action list can't be empty!");
        }
    }

    public void prepare(@NotNull List<Action> actions) throws TransactionPrepareError {
        this.prepare(actions, new ArrayList<Action>());
    }

    public void prepare(@NotNull List<Action> actions, @NotNull List<Action> contextFreeActions) throws TransactionPrepareError {
        this.prepare(actions, contextFreeActions, new ArrayList<String>());
    }

    public void prepare(@NotNull List<Action> actions, @NotNull List<Action> contextFreeActions, @NotNull List<String> contextFreeData) throws TransactionPrepareError {
        GetBlockInfoResponse getBlockInfoResponse;
        GetInfoResponse getInfoResponse;
        if (actions.isEmpty()) {
            throw new TransactionPrepareInputError("Action list can't be empty!");
        }
        Transaction preparingTransaction = new Transaction("", BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, contextFreeActions, actions, new ArrayList<String>());
        ContextFreeData preparingContextFreeData = new ContextFreeData(contextFreeData);
        try {
            getInfoResponse = this.rpcProvider.getInfo();
        }
        catch (GetInfoRpcError getInfoRpcError) {
            throw new TransactionPrepareRpcError("Error happened on calling GetInfo RPC.", getInfoRpcError);
        }
        if (Strings.isNullOrEmpty((String)this.chainId)) {
            if (Strings.isNullOrEmpty((String)getInfoResponse.getChainId())) {
                throw new TransactionPrepareError("Chain id from back end is empty!");
            }
            this.chainId = getInfoResponse.getChainId();
        } else if (!Strings.isNullOrEmpty((String)getInfoResponse.getChainId()) && !getInfoResponse.getChainId().equals(this.chainId)) {
            throw new TransactionPrepareError(String.format("Provided chain id %s does not match chain id %s", this.chainId, getInfoResponse.getChainId()));
        }
        boolean useLastIrreversibleConfig = this.transactionConfig.getUseLastIrreversible();
        int blockBehindConfig = this.transactionConfig.getBlocksBehind();
        BigInteger taposBlockNum = useLastIrreversibleConfig ? getInfoResponse.getLastIrreversibleBlockNum() : (getInfoResponse.getHeadBlockNum().compareTo(BigInteger.valueOf(blockBehindConfig)) > 0 ? getInfoResponse.getHeadBlockNum().subtract(BigInteger.valueOf(blockBehindConfig)) : BigInteger.valueOf(blockBehindConfig));
        try {
            getBlockInfoResponse = this.rpcProvider.getBlockInfo(new GetBlockInfoRequest(taposBlockNum));
        }
        catch (GetBlockInfoRpcError getBlockInfoRpcError) {
            throw new TransactionPrepareRpcError("Error happened on calling GetBlockInfo RPC.", getBlockInfoRpcError);
        }
        if (preparingTransaction.getExpiration().isEmpty()) {
            long taposBlockTime;
            String strHeadBlockTime = getBlockInfoResponse.getTimestamp();
            try {
                taposBlockTime = DateFormatter.convertBackendTimeToMilli(strHeadBlockTime);
            }
            catch (ParseException e) {
                throw new TransactionPrepareError("Failed to parse TAPOS block time", e);
            }
            int expiresSeconds = this.transactionConfig.getExpiresSeconds();
            long expirationTimeInMilliseconds = taposBlockTime + (long)(expiresSeconds * 1000);
            preparingTransaction.setExpiration(DateFormatter.convertMilliSecondToBackendTimeString(expirationTimeInMilliseconds));
        }
        BigInteger refBlockNum = getBlockInfoResponse.getBlockNum().and(BigInteger.valueOf(65535L));
        BigInteger refBlockPrefix = getBlockInfoResponse.getRefBlockPrefix();
        preparingTransaction.setRefBlockNum(refBlockNum);
        preparingTransaction.setRefBlockPrefix(refBlockPrefix);
        this.finishPreparing(preparingTransaction, preparingContextFreeData);
    }

    public boolean sign() throws TransactionSignError {
        EosioTransactionSignatureRequest eosioTransactionSignatureRequest;
        try {
            eosioTransactionSignatureRequest = this.createSignatureRequest();
        }
        catch (TransactionCreateSignatureRequestError transactionCreateSignatureRequestError) {
            throw new TransactionSignError("Error happened on creating signature request for Signature Provider to sign!", transactionCreateSignatureRequestError);
        }
        try {
            EosioTransactionSignatureResponse eosioTransactionSignatureResponse = this.getSignature(eosioTransactionSignatureRequest);
            if (eosioTransactionSignatureResponse.getError() != null) {
                throw eosioTransactionSignatureResponse.getError();
            }
        }
        catch (TransactionGetSignatureError transactionGetSignatureError) {
            throw new TransactionSignError(transactionGetSignatureError);
        }
        catch (SignatureProviderError signatureProviderError) {
            throw new TransactionSignError("Error happened on the response of getSignature.", signatureProviderError);
        }
        return true;
    }

    @NotNull
    public SendTransactionResponse broadcast() throws TransactionBroadCastError {
        if (this.serializedTransaction == null || this.serializedTransaction.isEmpty()) {
            throw new TransactionBroadCastError("Serialized Transaction is empty or has not been populated. Make sure to call prepare then sign before calling broadcast");
        }
        if (this.signatures.isEmpty()) {
            throw new TransactionBroadCastEmptySignatureError("Can't call broadcast because Signature is empty. Make sure of calling sign before calling broadcast.");
        }
        SendTransactionRequest sendTransactionRequest = new SendTransactionRequest(this.signatures, 0, this.contextFreeData.getHexed(), this.serializedTransaction);
        try {
            return this.sendTransaction(sendTransactionRequest);
        }
        catch (TransactionSendTransactionError transactionSendTransactionError) {
            throw new TransactionBroadCastError("Error happened on sending transaction to chain!", transactionSendTransactionError);
        }
    }

    @NotNull
    public SendTransactionResponse signAndBroadcast() throws TransactionSignAndBroadCastError {
        EosioTransactionSignatureRequest eosioTransactionSignatureRequest;
        try {
            eosioTransactionSignatureRequest = this.createSignatureRequest();
        }
        catch (TransactionCreateSignatureRequestError transactionCreateSignatureRequestError) {
            throw new TransactionSignAndBroadCastError(transactionCreateSignatureRequestError);
        }
        try {
            this.getSignature(eosioTransactionSignatureRequest);
        }
        catch (TransactionGetSignatureError transactionGetSignatureError) {
            throw new TransactionSignAndBroadCastError(transactionGetSignatureError);
        }
        if (this.serializedTransaction == null || this.serializedTransaction.isEmpty()) {
            throw new TransactionSignAndBroadCastError("Serialized Transaction is empty or has not been populated. Make sure to call prepare then sign before calling sign and broadcast");
        }
        if (this.signatures.isEmpty()) {
            throw new TransactionSignAndBroadCastError("Can't call sign and broadcast because Signature is empty. Make sure of calling sign before calling sign and broadcast.");
        }
        SendTransactionRequest sendTransactionRequest = new SendTransactionRequest(this.signatures, 0, this.contextFreeData.getHexed(), this.serializedTransaction);
        try {
            return this.sendTransaction(sendTransactionRequest);
        }
        catch (TransactionSendTransactionError transactionSendTransactionError) {
            throw new TransactionSignAndBroadCastError(transactionSendTransactionError);
        }
    }

    @Nullable
    public String toJSON() {
        return Utils.getGson("yyyy-MM-dd'T'HH:mm:ss.SSS").toJson((Object)this.transaction);
    }

    @Nullable
    public String serialize() throws TransactionSerializeError {
        if (this.serializedTransaction != null && !this.serializedTransaction.isEmpty()) {
            return this.serializedTransaction;
        }
        try {
            return this.serializeTransaction();
        }
        catch (TransactionCreateSignatureRequestError transactionCreateSignatureRequestError) {
            throw new TransactionSerializeError("Error happened on calling serializeTransaction", transactionCreateSignatureRequestError);
        }
    }

    @NotNull
    private EosioTransactionSignatureRequest createSignatureRequest() throws TransactionCreateSignatureRequestError {
        if (this.transaction == null) {
            throw new TransactionCreateSignatureRequestError("Transaction must be initialized before this method could be called! call prepare for initialize Transaction");
        }
        if (this.transaction.getActions().isEmpty()) {
            throw new TransactionCreateSignatureRequestError("Action list can't be empty!");
        }
        this.serializedTransaction = this.serializeTransaction();
        EosioTransactionSignatureRequest eosioTransactionSignatureRequest = new EosioTransactionSignatureRequest(this.serializedTransaction, null, this.chainId, null, this.isTransactionModificationAllowed, this.contextFreeData.getSerialized());
        if (this.requiredKeys != null && !this.requiredKeys.isEmpty()) {
            eosioTransactionSignatureRequest.setSigningPublicKeys(this.requiredKeys);
            return eosioTransactionSignatureRequest;
        }
        if (this.availableKeys == null || this.availableKeys.isEmpty()) {
            try {
                this.availableKeys = this.signatureProvider.getAvailableKeys();
            }
            catch (GetAvailableKeysError getAvailableKeysError) {
                throw new TransactionCreateSignatureRequestKeyError("Error happened on getAvailableKeys from SignatureProvider!", getAvailableKeysError);
            }
            if (this.availableKeys.isEmpty()) {
                throw new TransactionCreateSignatureRequestEmptyAvailableKeyError("Signature provider return no available key");
            }
        }
        try {
            GetRequiredKeysResponse getRequiredKeysResponse = this.rpcProvider.getRequiredKeys(new GetRequiredKeysRequest(this.availableKeys, this.transaction));
            if (getRequiredKeysResponse.getRequiredKeys() == null || getRequiredKeysResponse.getRequiredKeys().isEmpty()) {
                throw new TransactionCreateSignatureRequestRequiredKeysEmptyError("GetRequiredKeys RPC returned no required keys");
            }
            List<String> backendRequiredKeys = getRequiredKeysResponse.getRequiredKeys();
            if (!this.availableKeys.containsAll(backendRequiredKeys)) {
                throw new TransactionCreateSignatureRequestRequiredKeysEmptyError("Required keys from back end are not available in available keys from Signature Provider.");
            }
            this.requiredKeys = backendRequiredKeys;
        }
        catch (GetRequiredKeysRpcError getRequiredKeysRpcError) {
            throw new TransactionCreateSignatureRequestRpcError("Error happened on calling getRequiredKeys RPC call.", getRequiredKeysRpcError);
        }
        eosioTransactionSignatureRequest.setSigningPublicKeys(this.requiredKeys);
        return eosioTransactionSignatureRequest;
    }

    @NotNull
    private EosioTransactionSignatureResponse getSignature(EosioTransactionSignatureRequest eosioTransactionSignatureRequest) throws TransactionGetSignatureError {
        EosioTransactionSignatureResponse eosioTransactionSignatureResponse;
        try {
            eosioTransactionSignatureResponse = this.signatureProvider.signTransaction(eosioTransactionSignatureRequest);
            if (eosioTransactionSignatureResponse.getError() != null) {
                throw eosioTransactionSignatureResponse.getError();
            }
        }
        catch (SignatureProviderError signatureProviderError) {
            throw new TransactionGetSignatureSigningError("Error happened on calling sign transaction of Signature provider", signatureProviderError);
        }
        if (Strings.isNullOrEmpty((String)eosioTransactionSignatureResponse.getSerializedTransaction())) {
            throw new TransactionGetSignatureSigningError("Serialized transaction come back empty from Signature Provider");
        }
        if (eosioTransactionSignatureResponse.getSignatures().isEmpty()) {
            throw new TransactionGetSignatureSigningError("Signatures come back empty from Signature Provider");
        }
        this.originalTransaction = this.transaction;
        if (this.serializedTransaction != null && !this.serializedTransaction.equals(eosioTransactionSignatureResponse.getSerializedTransaction())) {
            String transactionJSON;
            if (!this.isTransactionModificationAllowed) {
                throw new TransactionGetSignatureNotAllowModifyTransactionError("The transaction is not allowed to be modified but was modified by signature provider!");
            }
            try {
                transactionJSON = this.serializationProvider.deserializeTransaction(eosioTransactionSignatureResponse.getSerializedTransaction());
                if (transactionJSON == null || transactionJSON.isEmpty()) {
                    throw new DeserializeTransactionError("Deserialized transaction is null or empty");
                }
            }
            catch (DeserializeTransactionError deserializeTransactionError) {
                throw new TransactionGetSignatureDeserializationError("Error happened on calling deserializeTransaction to refresh transaction object with new values", deserializeTransactionError);
            }
            this.transaction = (Transaction)Utils.getGson("yyyy-MM-dd'T'HH:mm:ss.SSS").fromJson(transactionJSON, Transaction.class);
        }
        this.signatures = new ArrayList<String>();
        this.signatures.addAll(eosioTransactionSignatureResponse.getSignatures());
        this.serializedTransaction = eosioTransactionSignatureResponse.getSerializedTransaction();
        return eosioTransactionSignatureResponse;
    }

    @NotNull
    private SendTransactionResponse sendTransaction(SendTransactionRequest sendTransactionRequest) throws TransactionSendTransactionError {
        try {
            return this.rpcProvider.sendTransaction(sendTransactionRequest);
        }
        catch (SendTransactionRpcError sendTransactionRpcError) {
            throw new TransactionSendTransactionError("Error happened on calling sendTransaction RPC call", sendTransactionRpcError);
        }
    }

    @NotNull
    private String serializeTransaction() throws TransactionCreateSignatureRequestError {
        String _serializedTransaction;
        AbiEosSerializationObject actionAbiEosSerializationObject;
        Transaction clonedTransaction;
        try {
            clonedTransaction = this.getDeepClone();
        }
        catch (IOException e) {
            throw new TransactionCreateSignatureRequestError("Error happened on cloning transaction.", e);
        }
        catch (ClassNotFoundException e) {
            throw new TransactionCreateSignatureRequestError("Transaction class was not found", e);
        }
        if (clonedTransaction == null) {
            throw new TransactionCreateSignatureRequestError("Error happened on cloning transaction.");
        }
        if (this.chainId == null || this.chainId.isEmpty()) {
            try {
                GetInfoResponse getInfoResponse = this.rpcProvider.getInfo();
                this.chainId = getInfoResponse.getChainId();
            }
            catch (GetInfoRpcError getInfoRpcError) {
                throw new TransactionCreateSignatureRequestRpcError("Error happened on calling GetInfo RPC.", getInfoRpcError);
            }
        }
        for (Action action : clonedTransaction.getActions()) {
            actionAbiEosSerializationObject = this.serializeAction(action, this.chainId, this.abiProvider);
            action.setData(actionAbiEosSerializationObject.getHex());
        }
        if (!clonedTransaction.getContextFreeActions().isEmpty()) {
            for (Action contextFreeAction : clonedTransaction.getContextFreeActions()) {
                actionAbiEosSerializationObject = this.serializeContextFreeAction(contextFreeAction, this.chainId, this.abiProvider);
                contextFreeAction.setData(actionAbiEosSerializationObject.getHex());
            }
        }
        this.transaction = clonedTransaction;
        try {
            String clonedTransactionToJSON = Utils.getGson("yyyy-MM-dd'T'HH:mm:ss.SSS").toJson((Object)clonedTransaction);
            _serializedTransaction = this.serializationProvider.serializeTransaction(clonedTransactionToJSON);
            if (_serializedTransaction == null || _serializedTransaction.isEmpty()) {
                throw new TransactionCreateSignatureRequestSerializationError("Serialization of transaction worked fine but got back empty result!");
            }
        }
        catch (SerializeTransactionError serializeTransactionError) {
            throw new TransactionCreateSignatureRequestSerializationError("Error happened on serializing transaction", serializeTransactionError);
        }
        return _serializedTransaction;
    }

    @NotNull
    private AbiEosSerializationObject serializeAction(Action action, String chainId, IABIProvider abiProvider) throws TransactionCreateSignatureRequestError {
        AbiEosSerializationObject actionAbiEosSerializationObject = this.setupAbiEosSerializationObject(action, chainId, abiProvider);
        try {
            this.serializationProvider.serialize(actionAbiEosSerializationObject);
        }
        catch (SerializeError serializeError) {
            throw new TransactionCreateSignatureRequestSerializationError(String.format("Error happened on serializing action [%s]", action.getAccount()), serializeError);
        }
        return actionAbiEosSerializationObject;
    }

    @NotNull
    private AbiEosSerializationObject serializeContextFreeAction(Action action, String chainId, IABIProvider abiProvider) throws TransactionCreateSignatureRequestError {
        AbiEosSerializationObject actionAbiEosSerializationObject = this.setupAbiEosSerializationObject(action, chainId, abiProvider);
        try {
            if (action.hasData()) {
                this.serializationProvider.serialize(actionAbiEosSerializationObject);
            }
        }
        catch (SerializeError serializeError) {
            throw new TransactionCreateSignatureRequestSerializationError(String.format("Error happened on serializing action [%s]", action.getAccount()), serializeError);
        }
        return actionAbiEosSerializationObject;
    }

    @NotNull
    private AbiEosSerializationObject setupAbiEosSerializationObject(Action action, String chainId, IABIProvider abiProvider) throws TransactionCreateSignatureRequestAbiError {
        String actionAbiJSON;
        try {
            actionAbiJSON = abiProvider.getAbi(chainId, new EOSIOName(action.getAccount()));
        }
        catch (GetAbiError getAbiError) {
            throw new TransactionCreateSignatureRequestAbiError(String.format("Error happened on getting abi for contract [%s]", action.getAccount()), getAbiError);
        }
        AbiEosSerializationObject actionAbiEosSerializationObject = new AbiEosSerializationObject(action.getAccount(), action.getName(), null, actionAbiJSON);
        actionAbiEosSerializationObject.setHex("");
        actionAbiEosSerializationObject.setJson(action.getData());
        return actionAbiEosSerializationObject;
    }

    private Transaction getDeepClone() throws IOException, ClassNotFoundException {
        if (this.transaction == null) {
            return null;
        }
        return Utils.clone(this.transaction);
    }

    private void finishPreparing(Transaction preparingTransaction, ContextFreeData preparingContextFreeData) {
        this.transaction = preparingTransaction;
        this.contextFreeData = preparingContextFreeData;
        if (!Strings.isNullOrEmpty((String)this.serializedTransaction)) {
            this.serializedTransaction = "";
        }
    }

    @Nullable
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Nullable
    public Transaction getOriginalTransaction() {
        return this.originalTransaction;
    }

    @NotNull
    public List<String> getSignatures() {
        return this.signatures;
    }

    @Nullable
    public String getSerializedTransaction() {
        return this.serializedTransaction;
    }

    @NotNull
    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public void setTransactionConfig(@NotNull TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public void setChainId(@Nullable String chainId) {
        this.chainId = chainId;
    }

    public void setAvailableKeys(@NotNull List<String> availableKeys) {
        this.availableKeys = availableKeys;
    }

    public void setRequiredKeys(@NotNull List<String> requiredKeys) {
        this.requiredKeys = requiredKeys;
    }

    public boolean isTransactionModificationAllowed() {
        return this.isTransactionModificationAllowed;
    }

    public void setIsTransactionModificationAllowed(boolean isTransactionModificationAllowed) {
        this.isTransactionModificationAllowed = isTransactionModificationAllowed;
    }

    public ContextFreeData getContextFreeData() {
        return this.contextFreeData;
    }

    public String getPackedTransactionV0() throws SerializePackedTransactionError {
        String json = Utils.getGson("yyyy-MM-dd'T'HH:mm:ss.SSS").toJson((Object)this.toJSON());
        String packedTransactionV0 = this.serializationProvider.serializePackedTransaction(json);
        return PACKED_TRANSACTION_V0_PREFIX + packedTransactionV0;
    }
}

