/*
 * Decompiled with CFR 0.152.
 */
package one.block.eosiojava.models.signatureProvider;

import java.util.List;
import one.block.eosiojava.models.signatureProvider.BinaryAbi;
import org.bouncycastle.util.encoders.Hex;

public class EosioTransactionSignatureRequest {
    private String serializedTransaction;
    private String serializedContextFreeData;
    private List<String> signingPublicKeys;
    private String chainId;
    private List<BinaryAbi> abis;
    private boolean isModifiable;

    public EosioTransactionSignatureRequest(String serializedTransaction, List<String> signingPublicKeys, String chainId, List<BinaryAbi> abis, boolean isModifiable, String serializedContextFreeData) {
        this.serializedTransaction = serializedTransaction;
        this.signingPublicKeys = signingPublicKeys;
        this.chainId = chainId;
        this.abis = abis;
        this.isModifiable = isModifiable;
        this.setSerializedContextFreeData(serializedContextFreeData);
    }

    public EosioTransactionSignatureRequest(String serializedTransaction, List<String> signingPublicKeys, String chainId, List<BinaryAbi> abis, boolean isModifiable) {
        this(serializedTransaction, signingPublicKeys, chainId, abis, isModifiable, "");
    }

    public String getSerializedTransaction() {
        return this.serializedTransaction;
    }

    public void setSerializedTransaction(String serializedTransaction) {
        this.serializedTransaction = serializedTransaction;
    }

    public String getSerializedContextFreeData() {
        return this.serializedContextFreeData;
    }

    public void setSerializedContextFreeData(String serializedContextFreeData) {
        this.serializedContextFreeData = serializedContextFreeData.isEmpty() ? Hex.toHexString((byte[])new byte[32]) : serializedContextFreeData;
    }

    public List<String> getSigningPublicKeys() {
        return this.signingPublicKeys;
    }

    public void setSigningPublicKeys(List<String> signingPublicKeys) {
        this.signingPublicKeys = signingPublicKeys;
    }

    public String getChainId() {
        return this.chainId;
    }

    public void setChainId(String chainId) {
        this.chainId = chainId;
    }

    public List<BinaryAbi> getAbis() {
        return this.abis;
    }

    public void setAbis(List<BinaryAbi> abis) {
        this.abis = abis;
    }

    public boolean isModifiable() {
        return this.isModifiable;
    }

    public void setModifiable(boolean modifiable) {
        this.isModifiable = modifiable;
    }
}

