/*
 * Decompiled with CFR 0.152.
 */
package one.block.eosiojava.models.rpcProvider;

import java.nio.ByteBuffer;
import java.util.List;
import org.bitcoinj.core.Sha256Hash;
import org.bouncycastle.util.encoders.Hex;
import org.jetbrains.annotations.NotNull;

public class ContextFreeData {
    @NotNull
    private List<String> data;
    @NotNull
    private byte[] rawBytes;

    public ContextFreeData(@NotNull List<String> contextFreeData) {
        this.setData(contextFreeData);
    }

    @NotNull
    public List<String> getData() {
        return this.data;
    }

    @NotNull
    public byte[] getBytes() {
        return this.rawBytes;
    }

    public String getHexed() {
        if (!this.hasData()) {
            return "";
        }
        return Hex.toHexString((byte[])this.getBytes()).toUpperCase();
    }

    public String getSerialized() {
        if (!this.hasData()) {
            return "";
        }
        return Hex.toHexString((byte[])Sha256Hash.hash((byte[])this.getBytes()));
    }

    public boolean hasData() {
        return !this.data.isEmpty();
    }

    private void setBytes(byte[] bytes) {
        this.rawBytes = bytes;
    }

    private void setData(List<String> contextFreeData) {
        this.data = contextFreeData;
        if (!this.hasData()) {
            this.setBytes(new byte[0]);
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.getTotalBytes(this.data));
        this.pushPrefix(buffer, this.data.size());
        for (String cfd : this.data) {
            byte[] cfdBytes = cfd.getBytes();
            this.pushPrefix(buffer, cfdBytes.length);
            buffer.put(cfdBytes);
        }
        this.setBytes(buffer.array());
    }

    private void pushPrefix(ByteBuffer buffer, int length) {
        while (true) {
            if (this.isLessThan128(length)) break;
            buffer.put((byte)(0x80 | length & 0x7F));
            length = this.subtract128(length);
        }
        buffer.put((byte)length);
    }

    private Integer getTotalBytes(List<String> contextFreeData) {
        int bytes = this.getByteSizePrefix(contextFreeData.size());
        for (String cfd : contextFreeData) {
            byte[] cfdBytes = cfd.getBytes();
            bytes += this.getByteSizePrefix(cfdBytes.length) + cfdBytes.length;
        }
        return bytes;
    }

    private Integer getByteSizePrefix(int length) {
        int size = 0;
        while (!this.isLessThan128(length)) {
            ++size;
            length = this.subtract128(length);
        }
        return ++size;
    }

    private boolean isLessThan128(int length) {
        return length >>> 7 == 0;
    }

    private int subtract128(int length) {
        return length >>> 7;
    }
}

