/*
 * Decompiled with CFR 0.152.
 */
package one.block.eosiojava.implementations;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import one.block.eosiojava.error.abiProvider.GetAbiError;
import one.block.eosiojava.interfaces.IABIProvider;
import one.block.eosiojava.interfaces.IRPCProvider;
import one.block.eosiojava.interfaces.ISerializationProvider;
import one.block.eosiojava.models.EOSIOName;
import one.block.eosiojava.models.rpcProvider.request.GetRawAbiRequest;
import one.block.eosiojava.models.rpcProvider.response.GetRawAbiResponse;
import one.block.eosiojava.utilities.ByteFormatter;
import org.jetbrains.annotations.NotNull;

public class ABIProviderImpl
implements IABIProvider {
    @NotNull
    private IRPCProvider rpcProvider;
    @NotNull
    private ISerializationProvider serializationProvider;
    @NotNull
    private Map<String, String> abiCache = new ConcurrentHashMap<String, String>();

    public ABIProviderImpl(@NotNull IRPCProvider rpcProvider, @NotNull ISerializationProvider serializationProvider) {
        this.rpcProvider = rpcProvider;
        this.serializationProvider = serializationProvider;
    }

    @Override
    @NotNull
    public Map<String, String> getAbis(@NotNull String chainId, @NotNull List<EOSIOName> accounts) throws GetAbiError {
        HashMap<String, String> returnAbis = new HashMap<String, String>();
        ArrayList<EOSIOName> uniqAccounts = new ArrayList<EOSIOName>(new HashSet<EOSIOName>(accounts));
        for (EOSIOName account : uniqAccounts) {
            String abiJsonString = this.getAbi(chainId, account);
            returnAbis.put(account.getAccountName(), abiJsonString);
        }
        return returnAbis;
    }

    @Override
    @NotNull
    public String getAbi(@NotNull String chainId, @NotNull EOSIOName account) throws GetAbiError {
        String cacheKey = chainId + account.getAccountName();
        String abiJsonString = this.abiCache.get(cacheKey);
        if (!Strings.isNullOrEmpty((String)abiJsonString)) {
            return abiJsonString;
        }
        GetRawAbiRequest getRawAbiRequest = new GetRawAbiRequest(account.getAccountName());
        try {
            String verificationHash;
            GetRawAbiResponse getRawAbiResponse = this.rpcProvider.getRawAbi(getRawAbiRequest);
            if (getRawAbiResponse == null) {
                throw new GetAbiError("No response retrieving ABI.");
            }
            String abi = getRawAbiResponse.getAbi();
            if (Strings.isNullOrEmpty((String)abi)) {
                throw new GetAbiError("Missing ABI from GetRawAbiResponse.");
            }
            ByteFormatter abiByteFormatter = ByteFormatter.createFromBase64(abi);
            String calculatedHash = abiByteFormatter.sha256().toHex().toLowerCase();
            if (!calculatedHash.equals(verificationHash = getRawAbiResponse.getAbiHash().toLowerCase())) {
                throw new GetAbiError("Calculated ABI hash does not match returned hash.");
            }
            if (!account.getAccountName().equals(getRawAbiResponse.getAccountName())) {
                throw new GetAbiError("Requested account name does not match returned account name.");
            }
            abiJsonString = this.serializationProvider.deserializeAbi(abiByteFormatter.toHex());
            if (abiJsonString.isEmpty()) {
                throw new GetAbiError("No ABI found for requested account name.");
            }
            this.abiCache.put(cacheKey, abiJsonString);
        }
        catch (Exception ex) {
            throw new GetAbiError("Error retrieving ABI from the chain.", ex);
        }
        return abiJsonString;
    }
}

