/*
 * Copyright (c) 2017-2019 block.one all rights reserved.
 */

package one.block.eosiojava.error.utilities;

import org.jetbrains.annotations.NotNull;

/**
 * Error class is used when there is an exception while attempting to convert a
 * signature to EOS format and the signature is not canonical.
 * <br>
 *     * This exception only happens with signatures signed by a key generated by the SECP256K1
 *     algorithm.
 * <br>
 *     * The signature must be recreated and tested to pass this exception.
 */
public class EosFormatterSignatureIsNotCanonicalError extends EOSFormatterError{
    public EosFormatterSignatureIsNotCanonicalError() {
    }

    public EosFormatterSignatureIsNotCanonicalError(@NotNull String message) {
        super(message);
    }

    public EosFormatterSignatureIsNotCanonicalError(@NotNull String message, @NotNull Exception exception) {
        super(message, exception);
    }

    public EosFormatterSignatureIsNotCanonicalError(@NotNull Exception exception) {
        super(exception);
    }
}
