/*
 * Decompiled with CFR 0.152.
 */
package one.block.eosiojavarpcprovider.implementations;

import com.google.gson.Gson;
import java.util.Locale;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import one.block.eosiojava.error.rpcProvider.GetBlockInfoRpcError;
import one.block.eosiojava.error.rpcProvider.GetBlockRpcError;
import one.block.eosiojava.error.rpcProvider.GetInfoRpcError;
import one.block.eosiojava.error.rpcProvider.GetRawAbiRpcError;
import one.block.eosiojava.error.rpcProvider.GetRequiredKeysRpcError;
import one.block.eosiojava.error.rpcProvider.PushTransactionRpcError;
import one.block.eosiojava.error.rpcProvider.RpcProviderError;
import one.block.eosiojava.error.rpcProvider.SendTransactionRpcError;
import one.block.eosiojava.interfaces.IRPCProvider;
import one.block.eosiojava.models.rpcProvider.request.GetBlockInfoRequest;
import one.block.eosiojava.models.rpcProvider.request.GetBlockRequest;
import one.block.eosiojava.models.rpcProvider.request.GetRawAbiRequest;
import one.block.eosiojava.models.rpcProvider.request.GetRequiredKeysRequest;
import one.block.eosiojava.models.rpcProvider.request.PushTransactionRequest;
import one.block.eosiojava.models.rpcProvider.request.SendTransactionRequest;
import one.block.eosiojava.models.rpcProvider.response.GetBlockInfoResponse;
import one.block.eosiojava.models.rpcProvider.response.GetBlockResponse;
import one.block.eosiojava.models.rpcProvider.response.GetInfoResponse;
import one.block.eosiojava.models.rpcProvider.response.GetRawAbiResponse;
import one.block.eosiojava.models.rpcProvider.response.GetRequiredKeysResponse;
import one.block.eosiojava.models.rpcProvider.response.PushTransactionResponse;
import one.block.eosiojava.models.rpcProvider.response.RPCResponseError;
import one.block.eosiojava.models.rpcProvider.response.SendTransactionResponse;
import one.block.eosiojavarpcprovider.error.EosioJavaRpcProviderCallError;
import one.block.eosiojavarpcprovider.error.EosioJavaRpcProviderInitializerError;
import one.block.eosiojavarpcprovider.implementations.IEosioJavaRpcProviderApi;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class EosioJavaRpcProviderImpl
implements IRPCProvider {
    @NotNull
    private String baseURL;
    @NotNull
    private Retrofit retrofit;
    @NotNull
    private IEosioJavaRpcProviderApi rpcProviderApi;

    public EosioJavaRpcProviderImpl(@NotNull String baseURL) throws EosioJavaRpcProviderInitializerError {
        this(baseURL, false);
    }

    public EosioJavaRpcProviderImpl(@NotNull String baseURL, boolean enableDebug) throws EosioJavaRpcProviderInitializerError {
        if (baseURL == null || baseURL.isEmpty()) {
            throw new EosioJavaRpcProviderInitializerError("Base URL cannot be empty or null.");
        }
        this.baseURL = baseURL;
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        if (enableDebug) {
            HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
            httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            httpClient.addInterceptor((Interceptor)httpLoggingInterceptor);
        }
        this.retrofit = new Retrofit.Builder().baseUrl(this.baseURL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(httpClient.build()).build();
        this.rpcProviderApi = (IEosioJavaRpcProviderApi)this.retrofit.create(IEosioJavaRpcProviderApi.class);
    }

    @NotNull
    private <O> O processCall(Call<O> call) throws Exception {
        Response response = call.execute();
        if (!response.isSuccessful()) {
            String additionalErrInfo = "No further error information available.";
            RPCResponseError rpcResponseError = null;
            if (response.errorBody() != null) {
                Gson gson = new Gson();
                rpcResponseError = (RPCResponseError)gson.fromJson(response.errorBody().charStream(), RPCResponseError.class);
                additionalErrInfo = rpcResponseError == null ? response.errorBody().string() : "See further error information in RPCProviderError.";
            }
            String msg = String.format(Locale.getDefault(), "Bad status code: %d (%s), returned from server. Additional error information: %s", response.code(), response.message(), additionalErrInfo);
            throw new EosioJavaRpcProviderCallError(msg, rpcResponseError);
        }
        if (response.body() == null) {
            throw new EosioJavaRpcProviderCallError("Empty response returned from the server.");
        }
        return (O)response.body();
    }

    @NotNull
    public GetInfoResponse getInfo() throws GetInfoRpcError {
        try {
            Call<GetInfoResponse> syncCall = this.rpcProviderApi.getInfo();
            return this.processCall(syncCall);
        }
        catch (Exception ex) {
            throw new GetInfoRpcError("Error retrieving chain information.", ex);
        }
    }

    @NotNull
    public GetBlockResponse getBlock(GetBlockRequest getBlockRequest) throws GetBlockRpcError {
        try {
            Call<GetBlockResponse> syncCall = this.rpcProviderApi.getBlock(getBlockRequest);
            return this.processCall(syncCall);
        }
        catch (Exception ex) {
            throw new GetBlockRpcError("Error retrieving block information.", ex);
        }
    }

    @NotNull
    public GetBlockInfoResponse getBlockInfo(GetBlockInfoRequest getBlockInfoRequest) throws GetBlockInfoRpcError {
        try {
            Call<GetBlockInfoResponse> syncCall = this.rpcProviderApi.getBlockInfo(getBlockInfoRequest);
            return this.processCall(syncCall);
        }
        catch (Exception ex) {
            throw new GetBlockInfoRpcError("Error retrieving block information.", ex);
        }
    }

    @NotNull
    public GetRawAbiResponse getRawAbi(GetRawAbiRequest getRawAbiRequest) throws GetRawAbiRpcError {
        try {
            Call<GetRawAbiResponse> syncCall = this.rpcProviderApi.getRawAbi(getRawAbiRequest);
            return this.processCall(syncCall);
        }
        catch (Exception ex) {
            throw new GetRawAbiRpcError("Error retrieving raw ABI.", ex);
        }
    }

    @NotNull
    public GetRequiredKeysResponse getRequiredKeys(GetRequiredKeysRequest getRequiredKeysRequest) throws GetRequiredKeysRpcError {
        try {
            Call<GetRequiredKeysResponse> syncCall = this.rpcProviderApi.getRequiredKeys(getRequiredKeysRequest);
            return this.processCall(syncCall);
        }
        catch (Exception ex) {
            throw new GetRequiredKeysRpcError("Error retrieving required keys.", ex);
        }
    }

    @NotNull
    public PushTransactionResponse pushTransaction(PushTransactionRequest pushTransactionRequest) throws PushTransactionRpcError {
        try {
            Call<PushTransactionResponse> syncCall = this.rpcProviderApi.pushTransaction(pushTransactionRequest);
            return this.processCall(syncCall);
        }
        catch (Exception ex) {
            throw new PushTransactionRpcError("Error pushing transaction.", ex);
        }
    }

    @NotNull
    public SendTransactionResponse sendTransaction(SendTransactionRequest sendTransactionRequest) throws SendTransactionRpcError {
        try {
            Call<SendTransactionResponse> syncCall = this.rpcProviderApi.sendTransaction(sendTransactionRequest);
            return this.processCall(syncCall);
        }
        catch (Exception ex) {
            throw new SendTransactionRpcError("Error sending transaction.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getAccount(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.getAccount(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error get account.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String pushTransactions(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.pushTransactions(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error pushing transactions.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getBlockHeaderState(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.getBlockHeaderState(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error get block header state.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getAbi(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.getAbi(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error get abi.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getCurrencyBalance(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.getCurrencyBalance(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error get current balance.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getCurrencyStats(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.getCurrencyStats(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error get current stats.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getProducers(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.getProducers(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error get producers.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getRawCodeAndAbi(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.getRawCodeAndAbi(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error get raw code and abi.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getTableByScope(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.getTableByScope(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error get table by scope.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getTableRows(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.getTableRows(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error get table rows.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getKvTableRows(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.getKvTableRows(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error get kv table rows.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getCode(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.getCode(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error get code.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getActions(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.getActions(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error get action.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getTransaction(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.getTransaction(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error get transaction.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getKeyAccounts(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.getKeyAccounts(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error get key accounts.", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String getControlledAccounts(RequestBody requestBody) throws RpcProviderError {
        try {
            Call<ResponseBody> syncCall = this.rpcProviderApi.getControlledAccounts(requestBody);
            try (ResponseBody responseBody = this.processCall(syncCall);){
                String string = responseBody.string();
                return string;
            }
        }
        catch (Exception ex) {
            throw new RpcProviderError("Error get controlled accounts.", ex);
        }
    }
}

