/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.types;

import com.casper.sdk.service.json.serialize.DigestJsonJSerializer;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.Objects;

@JsonSerialize(using=DigestJsonJSerializer.class)
public class Digest {
    private static final int BYTES_32_HEX = 32;
    private final byte[] hash;

    public Digest(String hash) {
        this(Digest.toBytes(hash));
    }

    public Digest(byte[] hash) {
        Objects.requireNonNull(hash, "Hash must not be null");
        if (hash.length != 32) {
            throw new IllegalArgumentException("Hash must be 32 bytes long: " + Arrays.toString(hash));
        }
        this.hash = hash;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public String toString() {
        return ByteUtils.encodeHexString(this.getHash());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Digest digest = (Digest)o;
        return Arrays.equals(this.hash, digest.hash);
    }

    public int hashCode() {
        return Arrays.hashCode(this.hash);
    }

    private static byte[] toBytes(String hash) {
        Objects.requireNonNull(hash, "Hash must not be null");
        if (hash.length() != 64) {
            throw new IllegalArgumentException("Hash must be 32 bytes long: " + hash);
        }
        return ByteUtils.decodeHex(hash);
    }
}

