/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.types;

import com.casper.sdk.types.Digest;
import java.security.Key;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class DeployParams {
    public static final long DEFAULT_TTL = 1800000L;
    private final Key accountKey;
    private final String chainName;
    private final int gasPrice;
    private final long ttl;
    private final String timestamp;
    private final List<Digest> dependencies;

    public DeployParams(Key accountKey, String chainName, Number gasPrice, Long timestamp, Long ttl, List<Digest> dependencies) {
        this.accountKey = accountKey;
        this.chainName = chainName;
        this.gasPrice = gasPrice != null ? gasPrice.intValue() : 1;
        this.timestamp = timestamp == null ? Instant.now().toString() : Instant.ofEpochMilli(timestamp).toString();
        this.ttl = ttl != null ? ttl : 1800000L;
        this.dependencies = dependencies != null ? dependencies : new ArrayList();
    }

    public <T extends Key> T getAccountKey() {
        return (T)this.accountKey;
    }

    public String getChainName() {
        return this.chainName;
    }

    public int getGasPrice() {
        return this.gasPrice;
    }

    public long getTtl() {
        return this.ttl;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public List<Digest> getDependencies() {
        return this.dependencies;
    }
}

