/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.types;

import com.casper.sdk.service.json.deserialize.PublicKeyJsonDeserializer;
import com.casper.sdk.service.json.serialize.PublicKeyJsonSerializer;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.types.AbstractCLType;
import com.casper.sdk.types.Algorithm;
import com.casper.sdk.types.CLType;
import com.casper.sdk.types.CLTypeInfo;
import com.casper.sdk.types.HasTag;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.Objects;

@JsonDeserialize(using=PublicKeyJsonDeserializer.class)
@JsonSerialize(using=PublicKeyJsonSerializer.class)
public class CLPublicKey
extends AbstractCLType
implements HasTag {
    protected final Algorithm algorithm;
    private final byte[] bytes;

    public CLPublicKey(byte[] bytes, Algorithm algorithm) {
        super(new CLTypeInfo(CLType.PUBLIC_KEY));
        Objects.requireNonNull(bytes, "bytes cannot be null");
        Objects.requireNonNull(algorithm, "keyAlgorithm cannot be null");
        this.algorithm = algorithm;
        this.bytes = bytes;
    }

    public CLPublicKey(String key, Algorithm algorithm) {
        this(ByteUtils.decodeHex(key), algorithm);
    }

    public CLPublicKey(String key) {
        this(ByteUtils.decodeHex(key));
    }

    public CLPublicKey(byte[] key) {
        this(CLPublicKey.removeAlgorithmBytes(key), Algorithm.fromId((char)key[0]));
    }

    private static byte[] removeAlgorithmBytes(byte[] key) {
        byte[] bytes = new byte[key.length - 1];
        System.arraycopy(key, 1, bytes, 0, key.length - 1);
        return bytes;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String toAccountHex() {
        return ByteUtils.encodeHexString(this.toAccount());
    }

    public byte[] toAccount() {
        return ByteUtils.concat({(byte)this.algorithm.getValue()}, this.bytes);
    }

    @Override
    public int getTag() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CLPublicKey that = (CLPublicKey)o;
        return this.algorithm == that.algorithm && Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.algorithm});
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }
}

