/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.types;

import java.util.HashMap;
import java.util.Map;

public enum Algorithm {
    ED25519(1),
    SECP256K1(2);

    private static final Map<Integer, Algorithm> map;
    private final int value;

    private Algorithm(int value) {
        this.value = value;
    }

    public static Algorithm fromId(char id) {
        if (id == '\u0001' || id == '1') {
            return ED25519;
        }
        if (id == '\u0002' || id == '2') {
            return SECP256K1;
        }
        throw new IllegalArgumentException("Unknown algorithm ID " + id);
    }

    public static Algorithm fromString(String algorithm) {
        switch (algorithm) {
            case "ECDSA": {
                return SECP256K1;
            }
            case "Ed25519": {
                return ED25519;
            }
        }
        throw new IllegalArgumentException("Unknown algorithm " + algorithm);
    }

    public int getValue() {
        return this.value;
    }

    static {
        map = new HashMap<Integer, Algorithm>();
        for (Algorithm key : Algorithm.values()) {
            map.put(key.value, key);
        }
    }
}

