/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.signing;

import com.casper.sdk.exceptions.SignatureException;
import com.casper.sdk.service.serialization.cltypes.TypesFactory;
import com.casper.sdk.service.signing.KeyPairBuilder;
import com.casper.sdk.types.Algorithm;
import com.casper.sdk.types.CLType;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;

abstract class AbstractKeyPairBuilder
implements KeyPairBuilder {
    private static final TypesFactory TYPES_FACTORY = new TypesFactory();
    private final Algorithm algorithm;

    AbstractKeyPairBuilder(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    KeyPair generateKeyPair(String algorithm, String curve, byte[] seed) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm, "BC");
            ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec(curve);
            SecureRandom secureRandom = seed != null ? new SecureRandom(seed) : new SecureRandom();
            keyPairGenerator.initialize(ecGenParameterSpec, secureRandom);
            return keyPairGenerator.generateKeyPair();
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    @Override
    public byte[] getPublicKeyRawBytes(PublicKey publicKey) {
        return TYPES_FACTORY.getInstance(CLType.PUBLIC_KEY).serialize(publicKey);
    }

    @Override
    public byte[] convertFromDER(byte[] signed) {
        return signed;
    }

    @Override
    public byte[] convertToDER(byte[] signed) {
        return signed;
    }
}

