/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.util;

import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TtlUtils {
    public static long getTtlLong(String strTtl) {
        if (strTtl != null) {
            Pattern p = Pattern.compile("\\p{Alpha}");
            Matcher m = p.matcher(strTtl);
            int unitIndex = m.find() ? m.start() : strTtl.length() - 1;
            String unit = strTtl.substring(unitIndex);
            long value = Long.parseLong(strTtl.substring(0, unitIndex));
            return value * TtlUtils.getMultiplier(unit);
        }
        return 0L;
    }

    public static String toTtlStr(long ttl) {
        return Duration.ofMillis(ttl).toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }

    private static long getMultiplier(String unit) {
        switch (unit) {
            case "d": {
                return 86400000L;
            }
            case "h": {
                return 3600000L;
            }
            case "m": {
                return 60000L;
            }
            case "s": {
                return 1000L;
            }
        }
        return 1L;
    }
}

