/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.types;

import com.casper.sdk.service.serialization.cltypes.TypesFactory;
import com.casper.sdk.service.serialization.cltypes.TypesSerializer;
import com.casper.sdk.service.serialization.types.ByteSerializer;
import com.casper.sdk.service.serialization.types.ByteSerializerFactory;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.types.CLPublicKey;
import com.casper.sdk.types.CLType;
import com.casper.sdk.types.DeployHeader;
import com.casper.sdk.types.Digest;
import java.util.List;

class DeployHeaderByteSerializer
implements ByteSerializer<DeployHeader> {
    private final ByteSerializerFactory factory;
    private final TypesSerializer u64Serializer;
    private final TypesSerializer stringSerializer;

    public DeployHeaderByteSerializer(ByteSerializerFactory factory, TypesFactory typesFactory) {
        this.factory = factory;
        this.u64Serializer = typesFactory.getInstance(CLType.U64);
        this.stringSerializer = typesFactory.getInstance(CLType.STRING);
    }

    @Override
    public byte[] toBytes(DeployHeader source) {
        return ByteUtils.concat(this.factory.getByteSerializerByType(CLPublicKey.class).toBytes(source.getAccount()), this.u64Serializer.serialize(source.getTimestamp()), this.u64Serializer.serialize(source.getTtl()), this.u64Serializer.serialize(source.getGasPrice()), this.factory.getByteSerializerByType(Digest.class).toBytes(source.getBodyHash()), this.factory.getByteSerializerByType(List.class).toBytes(source.getDependencies()), this.stringSerializer.serialize(source.getChainName()));
    }

    @Override
    public Class<DeployHeader> getType() {
        return DeployHeader.class;
    }
}

