/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.types;

import com.casper.sdk.service.serialization.cltypes.TypesFactory;
import com.casper.sdk.service.serialization.cltypes.TypesSerializer;
import com.casper.sdk.service.serialization.types.ByteSerializer;
import com.casper.sdk.service.serialization.types.ByteSerializerFactory;
import com.casper.sdk.service.serialization.util.ByteArrayBuilder;
import com.casper.sdk.types.CLOptionTypeInfo;
import com.casper.sdk.types.CLOptionValue;
import com.casper.sdk.types.CLType;
import com.casper.sdk.types.CLTypeInfo;
import com.casper.sdk.types.DeployExecutable;
import com.casper.sdk.types.DeployNamedArg;
import java.util.List;

abstract class AbstractDeployExecutableByteSerializer<T extends DeployExecutable>
implements ByteSerializer<T> {
    protected final TypesSerializer byteArraySerializer;
    protected final TypesSerializer stringSerializer;
    private final Class<T> type;
    private final ByteSerializerFactory factory;
    private final TypesSerializer optionSerializer;
    private final TypesSerializer u32Serializer;

    public AbstractDeployExecutableByteSerializer(Class<T> type, ByteSerializerFactory factory, TypesFactory typesFactory) {
        this.type = type;
        this.factory = factory;
        this.byteArraySerializer = typesFactory.getInstance(CLType.BYTE_ARRAY);
        this.optionSerializer = typesFactory.getInstance(CLType.OPTION);
        this.stringSerializer = typesFactory.getInstance(CLType.STRING);
        this.u32Serializer = typesFactory.getInstance(CLType.U32);
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public byte[] toBytes(T deployExecutable) {
        return new ByteArrayBuilder().append((byte)deployExecutable.getTag()).append(this.toSpecializedBytes(deployExecutable)).append(this.namedAgsToBytes(((DeployExecutable)deployExecutable).getArgs())).toByteArray();
    }

    protected abstract byte[] toSpecializedBytes(T var1);

    protected byte[] versionToBytes(Number version) {
        CLOptionValue clOptionValue = new CLOptionValue(version != null ? this.u32Serializer.serialize(version) : null, new CLOptionTypeInfo(new CLTypeInfo(CLType.U32)), (Object)version);
        return this.optionSerializer.serialize(clOptionValue);
    }

    private byte[] namedAgsToBytes(List<DeployNamedArg> args) {
        ByteArrayBuilder builder = new ByteArrayBuilder();
        builder.append(this.u32Serializer.serialize(args.size()));
        args.forEach(deployNamedArg -> builder.append(this.factory.getByteSerializer(deployNamedArg).toBytes((DeployNamedArg)deployNamedArg)));
        return builder.toByteArray();
    }
}

