/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.cltypes;

import com.casper.sdk.exceptions.ConversionException;
import com.casper.sdk.service.serialization.cltypes.TypesSerializer;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.service.serialization.util.NumberUtils;
import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;

abstract class VariableLengthNumberSerializer
implements TypesSerializer {
    private final int maxBytes;

    VariableLengthNumberSerializer(int maxBytes) {
        this.maxBytes = maxBytes;
    }

    @Override
    public byte[] serialize(Object toSerialize) {
        BigInteger bigInt = NumberUtils.toBigInteger(toSerialize);
        byte[] bytes = bigInt.toByteArray();
        if (bytes.length > this.maxBytes) {
            throw new ConversionException(bigInt + " exceeds " + this.maxBytes + " bytes length");
        }
        if (bytes.length > 1 && bytes[0] == 0) {
            bytes = this.removeLeadingZeros(bytes);
        }
        ArrayUtils.reverse((byte[])bytes);
        return ByteUtils.concat({(byte)bytes.length}, bytes);
    }

    private byte[] removeLeadingZeros(byte[] bytes) {
        byte[] copy = new byte[bytes.length - 1];
        System.arraycopy(bytes, 1, copy, 0, bytes.length - 1);
        return copy;
    }
}

