/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.cltypes;

import com.casper.sdk.service.serialization.cltypes.TypesSerializer;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.types.Algorithm;
import com.casper.sdk.types.CLPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;

class PublicKeySerializer
implements TypesSerializer {
    PublicKeySerializer() {
    }

    @Override
    public byte[] serialize(Object toSerialize) {
        if (toSerialize instanceof CLPublicKey) {
            return ((CLPublicKey)toSerialize).toAccount();
        }
        if (toSerialize instanceof BCECPublicKey) {
            return this.getSECP256K1PublicKeyRawBytes((BCECPublicKey)toSerialize);
        }
        if (toSerialize instanceof BCEdDSAPublicKey) {
            return this.getED25519PublicKeyRawBytes((BCEdDSAPublicKey)toSerialize);
        }
        return new byte[0];
    }

    private byte[] getSECP256K1PublicKeyRawBytes(BCECPublicKey publicKey) {
        return ByteUtils.concat(ByteUtils.toByteArray(Algorithm.SECP256K1.getValue()), publicKey.getQ().getEncoded(true));
    }

    private byte[] getED25519PublicKeyRawBytes(BCEdDSAPublicKey publicKey) {
        return ByteUtils.concat(ByteUtils.toByteArray(Algorithm.ED25519.getValue()), publicKey.getPointEncoding());
    }
}

