/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.serialization.cltypes;

import com.casper.sdk.service.serialization.cltypes.AbstractTypesSerializer;
import com.casper.sdk.service.serialization.cltypes.TypesFactory;
import com.casper.sdk.service.serialization.util.ByteArrayBuilder;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.types.CLPublicKey;
import com.casper.sdk.types.Digest;
import java.security.PublicKey;

class ByteArraySerializer
extends AbstractTypesSerializer {
    public ByteArraySerializer(TypesFactory typesFactory) {
        super(typesFactory);
    }

    @Override
    public byte[] serialize(Object toSerialize) {
        byte[] originalBytes = this.toBytes(toSerialize);
        return new ByteArrayBuilder().append(this.getU32Serializer().serialize(originalBytes.length)).append(originalBytes).toByteArray();
    }

    private byte[] toBytes(Object toSerialize) {
        if (toSerialize instanceof String) {
            return ByteUtils.decodeHex((String)toSerialize);
        }
        if (toSerialize instanceof byte[]) {
            return (byte[])toSerialize;
        }
        if (toSerialize instanceof Digest) {
            return ((Digest)toSerialize).getHash();
        }
        if (toSerialize instanceof PublicKey || toSerialize instanceof CLPublicKey) {
            return this.getPublicKeySerializer().serialize(toSerialize);
        }
        return new byte[0];
    }
}

