/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.json.serialize;

import com.casper.sdk.types.CLByteArrayInfo;
import com.casper.sdk.types.CLMapTypeInfo;
import com.casper.sdk.types.CLOptionTypeInfo;
import com.casper.sdk.types.CLTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class CLTypeInfoSerializer
extends JsonSerializer<CLTypeInfo> {
    public void serialize(CLTypeInfo value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value != null) {
            if (value instanceof CLByteArrayInfo) {
                gen.writeStartObject();
                gen.writeFieldName(value.getType().getJsonName());
                gen.writeNumber(((CLByteArrayInfo)value).getSize());
                gen.writeEndObject();
            } else if (value instanceof CLOptionTypeInfo) {
                gen.writeStartObject();
                gen.writeFieldName(value.getType().getJsonName());
                gen.writeString(((CLOptionTypeInfo)value).getInnerType().getType().getJsonName());
                gen.writeEndObject();
            } else if (value instanceof CLMapTypeInfo) {
                gen.writeStartObject();
                gen.writeFieldName(value.getType().getJsonName());
                gen.writeStartObject();
                gen.writeFieldName("key");
                gen.getCodec().writeValue(gen, (Object)((CLMapTypeInfo)value).getKeyType());
                gen.writeFieldName("value");
                gen.getCodec().writeValue(gen, (Object)((CLMapTypeInfo)value).getValueType());
                gen.writeEndObject();
                gen.writeEndObject();
            } else {
                gen.writeString(value.getType().getJsonName());
            }
        }
    }
}

