/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.json.deserialize;

import java.util.Stack;

public class DeserializerContext {
    private static final ThreadLocal<Stack<String>> fieldNameStack = new ThreadLocal();

    public static void clear() {
        DeserializerContext.getFieldNameStack().clear();
    }

    public static void pushFieldName(String name) {
        DeserializerContext.getFieldNameStack().push(name);
    }

    public static String peekFieldName() {
        Stack<String> fieldNameStack = DeserializerContext.getFieldNameStack();
        return fieldNameStack.isEmpty() ? null : fieldNameStack.peek();
    }

    public static String popFieldName() {
        return DeserializerContext.getFieldNameStack().pop();
    }

    private static Stack<String> getFieldNameStack() {
        Stack<String> fieldNames = fieldNameStack.get();
        if (fieldNames == null) {
            fieldNames = new Stack();
            fieldNameStack.set(fieldNames);
        }
        return fieldNames;
    }
}

