/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.json.deserialize;

import com.casper.sdk.exceptions.ConversionException;
import com.casper.sdk.service.serialization.cltypes.CLValueBuilder;
import com.casper.sdk.types.CLByteArrayInfo;
import com.casper.sdk.types.CLMap;
import com.casper.sdk.types.CLMapTypeInfo;
import com.casper.sdk.types.CLOptionTypeInfo;
import com.casper.sdk.types.CLOptionValue;
import com.casper.sdk.types.CLType;
import com.casper.sdk.types.CLTypeInfo;
import com.casper.sdk.types.CLValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class CLValueJsonDeserializer
extends JsonDeserializer<CLValue> {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String CL_TYPE = "cl_type";
    private static final String BYTES = "bytes";
    private static final String PARSED = "parsed";

    public CLValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
        ObjectCodec codec = p.getCodec();
        return this.getClValue(codec.readTree(p));
    }

    private CLValue getClValue(TreeNode treeNode) {
        TreeNode typeNode = treeNode.get(CL_TYPE);
        TextNode bytesNode = (TextNode)treeNode.get(BYTES);
        CLTypeInfo clTypeInfo = this.getCLTypeInfo(typeNode);
        Object parsed = this.getParsed(treeNode.get(PARSED), clTypeInfo);
        if (clTypeInfo instanceof CLMapTypeInfo) {
            return this.deserializeMap((CLMapTypeInfo)clTypeInfo, bytesNode, parsed);
        }
        if (clTypeInfo instanceof CLOptionTypeInfo) {
            return new CLOptionValue(bytesNode.asText(), (CLOptionTypeInfo)clTypeInfo, parsed);
        }
        return new CLValue(bytesNode.asText(), clTypeInfo, parsed);
    }

    private CLType getClType(TreeNode typeNode) {
        if (typeNode instanceof TextNode) {
            return CLType.fromString(((TextNode)typeNode).asText());
        }
        String typeName = (String)typeNode.fieldNames().next();
        return CLType.fromString(typeName);
    }

    private CLTypeInfo getCLTypeInfo(TreeNode typeNode) {
        CLType clType = this.getClType(typeNode);
        if (CLType.BYTE_ARRAY == clType) {
            TreeNode sizeNode = typeNode.get(CLType.BYTE_ARRAY.getJsonName());
            int size = 0;
            if (sizeNode instanceof NumericNode) {
                size = ((NumericNode)sizeNode).asInt();
            }
            return new CLByteArrayInfo(size);
        }
        if (CLType.OPTION == clType) {
            return new CLOptionTypeInfo(this.getCLTypeInfo(typeNode.get(CLType.OPTION.getJsonName())));
        }
        if (CLType.MAP == clType) {
            return new CLMapTypeInfo(this.getCLTypeInfo((TreeNode)((ObjectNode)typeNode).findValue(KEY)), this.getCLTypeInfo((TreeNode)((ObjectNode)typeNode).findValue(VALUE)));
        }
        return new CLTypeInfo(clType);
    }

    private Object getParsed(TreeNode treeNode, CLTypeInfo clTypeInfo) {
        if (treeNode instanceof TextNode) {
            return ((TextNode)treeNode).asText();
        }
        if (treeNode instanceof NumericNode && CLType.isNumeric(clTypeInfo.getType())) {
            return ((NumericNode)treeNode).bigIntegerValue();
        }
        if (CLType.MAP == clTypeInfo.getType()) {
            return treeNode;
        }
        return null;
    }

    CLMap deserializeMap(CLMapTypeInfo typeInfo, TextNode bytesNode, Object parsed) {
        return new CLMap(bytesNode.asText(), typeInfo, this.parseMap(typeInfo, parsed));
    }

    private Map<CLValue, CLValue> parseMap(CLMapTypeInfo mapTypeInfo, Object parsed) {
        if (parsed instanceof String) {
            try {
                return this.parseMap(mapTypeInfo, new ObjectMapper().readTree((String)parsed));
            }
            catch (JsonProcessingException e) {
                throw new ConversionException(e);
            }
        }
        if (parsed instanceof Map) {
            return (Map)parsed;
        }
        if (parsed instanceof ArrayNode) {
            LinkedHashMap<CLValue, CLValue> map = new LinkedHashMap<CLValue, CLValue>();
            ((ArrayNode)parsed).iterator().forEachRemaining(node -> {
                JsonNode keyJson = node.findValue(KEY);
                JsonNode valueJson = node.findValue(VALUE);
                CLValue key = CLValueBuilder.buildCLValue(mapTypeInfo.getKeyType().getType(), keyJson.textValue());
                CLValue value = CLValueBuilder.buildCLValue(mapTypeInfo.getValueType().getType(), valueJson.textValue());
                map.put(key, value);
            });
            return map;
        }
        return null;
    }
}

