/*
 * Decompiled with CFR 0.152.
 */
package com.casper.sdk.service.hash;

import com.casper.sdk.exceptions.HashException;
import com.casper.sdk.service.serialization.util.ByteUtils;
import com.casper.sdk.types.Algorithm;
import com.rfksystems.blake2b.security.Blake2bProvider;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;

public class HashService {
    public String getAccountHash(String accountKey) {
        return ByteUtils.encodeHexString(this.getAccountHash(ByteUtils.decodeHex(accountKey)));
    }

    public byte[] getAccountHash(byte[] accountKey) {
        try {
            MessageDigest digest = MessageDigest.getInstance("BLAKE2B-256");
            digest.update(this.getAlgoNameBytes(accountKey));
            digest.update(new byte[1]);
            digest.update(accountKey, 1, accountKey.length - 1);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new HashException("Error getAccountHash", e);
        }
    }

    public byte[] getHash(byte[] in) {
        try {
            MessageDigest digest = MessageDigest.getInstance("BLAKE2B-256");
            digest.update(in);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new HashException("Error getHash", e);
        }
    }

    private byte[] getAlgoNameBytes(byte[] key) {
        if (key == null || key.length < 33) {
            throw new IllegalArgumentException("Key size must be equal or greater than 66 chars");
        }
        Algorithm algorithm = Algorithm.fromId((char)key[0]);
        switch (algorithm) {
            case ED25519: {
                if (key.length == 33) break;
                throw new IllegalArgumentException("Key length must be 66 chars (key " + key.length + ")");
            }
            case SECP256K1: {
                if (key.length == 34) break;
                throw new IllegalArgumentException("Key length must be 68 chars");
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown key prefix: [%s]", key[0]));
            }
        }
        return algorithm.name().toLowerCase().getBytes(StandardCharsets.UTF_8);
    }

    static {
        Security.addProvider((Provider)new Blake2bProvider());
    }
}

