/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.sf.jagg.exception.ParseException;
import net.sf.jagg.util.PropertyScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyParser {
    private static final boolean DEBUG = false;
    private String myPropertyText;
    private PropertyScanner myScanner;
    private String myPropertyName;
    private boolean amIMethod;
    private List<Object> myParameters = new ArrayList<Object>();
    private boolean amIFinished;
    private PropertyScanner.Token myNextToken;
    private String myNextLexeme;

    public PropertyParser() {
        this.setPropertyText("");
    }

    public PropertyParser(String propertyText) {
        this.setPropertyText(propertyText);
    }

    public void setPropertyText(String propertyText) {
        this.myPropertyText = propertyText;
        this.reset();
    }

    private void reset() {
        this.myPropertyName = null;
        this.amIMethod = false;
        this.myParameters.clear();
        this.amIFinished = false;
        this.myNextToken = null;
        this.myNextLexeme = null;
        this.myScanner = new PropertyScanner(this.myPropertyText);
    }

    public void parse() {
        PropertyScanner.Token token;
        this.amIFinished = false;
        this.myParameters.clear();
        if (this.myNextToken != null) {
            token = this.myNextToken;
            this.myNextToken = null;
            this.myNextLexeme = null;
        } else {
            token = this.myScanner.getNextToken();
        }
        if (token == PropertyScanner.Token.TOKEN_WHITESPACE) {
            token = this.myScanner.getNextToken();
        }
        if (token != PropertyScanner.Token.TOKEN_STRING) {
            throw new ParseException("Illegal token " + (Object)((Object)token) + " start to property or method name: \"" + this.myPropertyText + "\".");
        }
        token = this.parsePropertyOrMethod(this.myScanner);
        if (token == PropertyScanner.Token.TOKEN_WHITESPACE) {
            token = this.myScanner.getNextToken();
        }
        if (token == PropertyScanner.Token.TOKEN_PERIOD || token == PropertyScanner.Token.TOKEN_LEFT_BRACKET) {
            this.amIFinished = false;
            if (token == PropertyScanner.Token.TOKEN_PERIOD) {
                token = this.myScanner.getNextToken();
            }
        } else {
            if (token != PropertyScanner.Token.TOKEN_EOI) {
                throw new ParseException("Extra token " + (Object)((Object)token) + " found after ')': \"" + this.myPropertyText + "\".");
            }
            this.amIFinished = true;
        }
        this.myNextToken = token;
        this.myNextLexeme = this.myScanner.getCurrLexeme();
    }

    private PropertyScanner.Token parsePropertyOrMethod(PropertyScanner scanner) {
        String lexeme = "";
        boolean wasQuoted = false;
        if (this.myNextLexeme != null) {
            this.myPropertyName = this.myNextLexeme;
            this.myNextLexeme = null;
        } else {
            this.myPropertyName = scanner.getCurrLexeme();
        }
        PropertyScanner.Token token = scanner.getNextToken();
        if (token == PropertyScanner.Token.TOKEN_WHITESPACE) {
            token = scanner.getNextToken();
        }
        if (token == PropertyScanner.Token.TOKEN_EOI || token == PropertyScanner.Token.TOKEN_LEFT_BRACKET || token == PropertyScanner.Token.TOKEN_PERIOD) {
            this.amIMethod = false;
            return token;
        }
        if (token != PropertyScanner.Token.TOKEN_LEFT_PAREN) {
            throw new ParseException("Method name must start with '(': \"" + this.myPropertyText + "\".");
        }
        this.amIMethod = true;
        token = scanner.getNextToken();
        while (token.getCode() >= 0 && token != PropertyScanner.Token.TOKEN_RIGHT_PAREN) {
            switch (token) {
                case TOKEN_WHITESPACE: {
                    break;
                }
                case TOKEN_STRING: {
                    lexeme = scanner.getCurrLexeme();
                    break;
                }
                case TOKEN_COMMA: {
                    if (wasQuoted || lexeme.length() > 0) {
                        this.myParameters.add(PropertyParser.getTypedParameter(lexeme, wasQuoted));
                    }
                    wasQuoted = false;
                    break;
                }
                case TOKEN_DOUBLE_QUOTE: {
                    wasQuoted = true;
                    break;
                }
                case TOKEN_SINGLE_QUOTE: {
                    wasQuoted = true;
                    break;
                }
                case TOKEN_EOI: {
                    throw new ParseException("'(' found without ')': \"" + this.myPropertyText + "\".");
                }
                default: {
                    throw new ParseException("Parse error occurred: token " + (Object)((Object)token) + " found: \"" + this.myPropertyText + "\".");
                }
            }
            token = scanner.getNextToken();
        }
        if (token.getCode() < 0) {
            throw new ParseException("A parse error occured: \"" + this.myPropertyText + "\".");
        }
        if (wasQuoted || lexeme.length() > 0) {
            Object value = PropertyParser.getTypedParameter(lexeme, wasQuoted);
            this.myParameters.add(value);
        }
        token = scanner.getNextToken();
        return token;
    }

    public static Object getTypedParameter(String parameter, boolean wasQuoted) {
        if (wasQuoted) {
            if (parameter == null || parameter.length() == 0) {
                return "";
            }
            return parameter;
        }
        if (parameter.matches(".*[A-Za-z]+.*")) {
            if ("true".equalsIgnoreCase(parameter)) {
                return true;
            }
            if ("false".equalsIgnoreCase(parameter)) {
                return false;
            }
            if ("null".equalsIgnoreCase(parameter)) {
                return null;
            }
            if (parameter.contains(":")) {
                int index = parameter.indexOf(":");
                String className = parameter.substring(0, index);
                String enumName = parameter.substring(index + 1);
                try {
                    Class<?> enumClass = Class.forName(className);
                    return Enum.valueOf(enumClass, enumName);
                }
                catch (ClassNotFoundException e) {
                    throw new ParseException("Unrecognized Enum: \"" + className + "\"", e);
                }
                catch (ClassCastException e) {
                    throw new ParseException("Not an Enum: \"" + className + "\"", e);
                }
            }
            return parameter;
        }
        if (parameter.matches("[-]?[0-9]+\\.[0-9]*")) {
            try {
                Double result = Double.valueOf(parameter);
                return result;
            }
            catch (NumberFormatException ignored) {
                try {
                    BigDecimal result = new BigDecimal(parameter);
                    return result;
                }
                catch (NumberFormatException ignored2) {
                    return parameter;
                }
            }
        }
        if (parameter.matches("[-]?[0-9]+")) {
            try {
                Byte result = Byte.valueOf(parameter);
                return result;
            }
            catch (NumberFormatException ignored) {
                try {
                    Short result = Short.valueOf(parameter);
                    return result;
                }
                catch (NumberFormatException ignored3) {
                    try {
                        Integer result = Integer.valueOf(parameter);
                        return result;
                    }
                    catch (NumberFormatException ignored4) {
                        try {
                            Long result = Long.valueOf(parameter);
                            return result;
                        }
                        catch (NumberFormatException ignored5) {
                            try {
                                BigInteger result = new BigInteger(parameter);
                                return result;
                            }
                            catch (NumberFormatException numberFormatException) {
                                return parameter;
                            }
                        }
                    }
                }
            }
        }
        return parameter;
    }

    public String getPropertyName() {
        return this.myPropertyName;
    }

    public boolean isMethod() {
        return this.amIMethod;
    }

    public List<Object> getParameters() {
        if (!this.amIMethod) {
            return null;
        }
        return this.myParameters;
    }

    public boolean isFinished() {
        return this.amIFinished;
    }
}

