/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.util;

import java.util.Comparator;
import java.util.List;
import net.sf.jagg.Aggregator;
import net.sf.jagg.exception.ExpectedComparableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesComparator<T>
implements Comparator<T> {
    private List<String> myProperties;
    private int mySize;

    public PropertiesComparator(List<String> properties) {
        this.myProperties = properties;
        this.mySize = properties.size();
    }

    public List<String> getProperties() {
        return this.myProperties;
    }

    @Override
    public int compare(T o1, T o2) throws ExpectedComparableException {
        for (int i = 0; i < this.mySize; ++i) {
            String property = this.myProperties.get(i);
            Comparable value1 = (Comparable)Aggregator.getValueFromProperty(o1, property);
            Comparable value2 = (Comparable)Aggregator.getValueFromProperty(o2, property);
            try {
                int comp = value1 == null ? (value2 == null ? 0 : 1) : (value2 == null ? -1 : value1.compareTo(value2));
                if (comp == 0) continue;
                return comp;
            }
            catch (ClassCastException e) {
                throw new ExpectedComparableException("Property \"" + property + "\" needs to be Comparable.");
            }
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PropertiesComparator) {
            PropertiesComparator otherComp = (PropertiesComparator)obj;
            if (this.mySize != otherComp.mySize) {
                return false;
            }
            for (int i = 0; i < this.mySize; ++i) {
                if (this.myProperties.get(i).equals(otherComp.myProperties.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hc = 0;
        for (String property : this.myProperties) {
            hc = 31 * hc + property.hashCode();
        }
        return hc;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("PropertiesComparator(");
        for (int i = 0; i < this.myProperties.size(); ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.myProperties.get(i));
        }
        buf.append(")");
        return buf.toString();
    }
}

