/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sf.jagg.Aggregator;
import net.sf.jagg.exception.ExpectedComparableException;
import net.sf.jagg.model.AnalyticValue;
import net.sf.jagg.model.OrderByClause;
import net.sf.jagg.model.OrderByElement;
import net.sf.jagg.model.PartitionClause;
import net.sf.jagg.util.AnalyticValuePropertiesComparator;
import net.sf.jagg.util.PropertiesComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionAndOrderByComparator<T>
implements Comparator<AnalyticValue<T>> {
    private PropertiesComparator<T> myPropertiesComparator;
    private AnalyticValuePropertiesComparator<T> myAnalyticValuePropertiesComparator;
    private List<OrderByElement> myOrderByElements;
    private int myOrderBySize;

    public PartitionAndOrderByComparator() {
        this(null, null);
    }

    public PartitionAndOrderByComparator(PartitionClause part, OrderByClause orderBy) {
        ArrayList<String> properties = part != null ? part.getProperties() : new ArrayList<String>(0);
        this.myPropertiesComparator = new PropertiesComparator(properties);
        this.myAnalyticValuePropertiesComparator = new AnalyticValuePropertiesComparator(properties);
        if (orderBy != null) {
            this.myOrderByElements = orderBy.getElements();
            this.myOrderBySize = this.myOrderByElements.size();
        } else {
            this.myOrderByElements = new ArrayList<OrderByElement>(0);
            this.myOrderBySize = 0;
        }
    }

    public AnalyticValuePropertiesComparator<T> getPartitionComparator() {
        return this.myAnalyticValuePropertiesComparator;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.myOrderByElements;
    }

    @Override
    public int compare(AnalyticValue<T> o1, AnalyticValue<T> o2) throws UnsupportedOperationException {
        T t2;
        T t1 = o1.getObject();
        int comp = this.myPropertiesComparator.compare(t1, t2 = o2.getObject());
        if (comp != 0) {
            return comp;
        }
        for (int i = 0; i < this.myOrderBySize; ++i) {
            OrderByElement element = this.myOrderByElements.get(i);
            String property = element.getProperty();
            Comparable value1 = (Comparable)Aggregator.getValueFromProperty(t1, property);
            Comparable value2 = (Comparable)Aggregator.getValueFromProperty(t2, property);
            try {
                if (value1 == null) {
                    comp = value2 == null ? 0 : (element.getNullSort() == OrderByElement.NullSort.FIRST ? -1 : 1);
                } else if (value2 == null) {
                    comp = element.getNullSort() == OrderByElement.NullSort.FIRST ? 1 : -1;
                } else {
                    int n = comp = element.getSortDir() == OrderByElement.SortDir.ASC ? value1.compareTo(value2) : value2.compareTo(value1);
                }
                if (comp == 0) continue;
                return comp;
            }
            catch (ClassCastException e) {
                throw new ExpectedComparableException("Property \"" + property + "\" needs to be Comparable.");
            }
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PartitionAndOrderByComparator) {
            PartitionAndOrderByComparator otherComp = (PartitionAndOrderByComparator)obj;
            if (!this.myPropertiesComparator.equals(otherComp.myPropertiesComparator)) {
                return false;
            }
            if (this.myOrderBySize != otherComp.myOrderBySize) {
                return false;
            }
            for (int i = 0; i < this.myOrderBySize; ++i) {
                if (this.myOrderByElements.get(i).equals(otherComp.myOrderByElements.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hc = this.myPropertiesComparator.hashCode();
        for (OrderByElement element : this.myOrderByElements) {
            hc = 31 * hc + element.hashCode();
        }
        return hc;
    }

    public boolean covers(PartitionAndOrderByComparator<T> other) {
        int i;
        List<String> properties = this.myPropertiesComparator.getProperties();
        List<String> otherProperties = other.myPropertiesComparator.getProperties();
        List<OrderByElement> elements = this.getOrderByElements();
        List<OrderByElement> otherElements = other.getOrderByElements();
        if (properties.size() < otherProperties.size()) {
            return false;
        }
        for (i = 0; i < otherProperties.size(); ++i) {
            if (properties.get(i).equals(otherProperties.get(i))) continue;
            return false;
        }
        if (properties.size() > otherProperties.size()) {
            if (other.getOrderByElements().size() > 0) {
                return false;
            }
        } else {
            for (i = 0; i < otherElements.size(); ++i) {
                if (elements.get(i).equals(otherElements.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("PAOBC(");
        buf.append(this.myPropertiesComparator);
        buf.append(" orderBy(");
        for (int i = 0; i < this.myOrderByElements.size(); ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.myOrderByElements.get(i));
        }
        buf.append("))");
        return buf.toString();
    }
}

