/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jagg.exception.PropertyAccessException;
import net.sf.jagg.model.ChainedMethodCall;
import net.sf.jagg.model.MethodCall;
import net.sf.jagg.model.SelfMethodCall;
import net.sf.jagg.util.PropertyParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCache {
    private static final boolean DEBUG = false;
    private static MethodCache theMethodCache = null;
    private final Map<MethodDescriptor, ChainedMethodCall> myMethods = new HashMap<MethodDescriptor, ChainedMethodCall>();

    private MethodCache() {
    }

    public static MethodCache getMethodCache() {
        if (theMethodCache == null) {
            theMethodCache = new MethodCache();
        }
        return theMethodCache;
    }

    public void clear() {
        this.myMethods.clear();
    }

    public Object getValueFromProperty(Object value, String property) throws PropertyAccessException {
        if (".".equals(property)) {
            return value;
        }
        ChainedMethodCall methodCall = this.getMethodCallFromProperty(value, property);
        return methodCall.invoke(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChainedMethodCall getMethodCallFromProperty(Object value, String property) throws PropertyAccessException {
        MethodDescriptor lookup = new MethodDescriptor(value.getClass(), property);
        Map<MethodDescriptor, ChainedMethodCall> map = this.myMethods;
        synchronized (map) {
            ChainedMethodCall methodCall = this.myMethods.get(lookup);
            if (methodCall != null) return methodCall;
            if (".".equals(property)) {
                methodCall = new SelfMethodCall(value);
            } else {
                PropertyParser parser = new PropertyParser(property);
                methodCall = null;
                MethodCall prevMethodCall = null;
                Class<?> currValueClass = value.getClass();
                do {
                    MethodCall currMethodCall;
                    Method method;
                    Object[] parameterArray;
                    parser.parse();
                    if (parser.isMethod()) {
                        String methodName = parser.getPropertyName();
                        List<Object> parameters = parser.getParameters();
                        Class[] classes = new Class[parameters.size()];
                        for (int i = 0; i < parameters.size(); ++i) {
                            Class<?> theClass;
                            classes[i] = theClass = parameters.get(i).getClass();
                        }
                        parameterArray = parameters.toArray();
                        try {
                            method = currValueClass.getMethod(methodName, classes);
                        }
                        catch (NoSuchMethodException e) {
                            method = this.findMethod(currValueClass, methodName, classes);
                        }
                        if (method == null) throw new PropertyAccessException("Couldn't find Method: " + methodName);
                        this.assignParameters(method.getParameterTypes(), parameterArray);
                        currMethodCall = new MethodCall(method, parameterArray);
                    } else {
                        String methodName;
                        method = null;
                        parameterArray = null;
                        String simpleProperty = parser.getPropertyName();
                        try {
                            methodName = "get" + simpleProperty.substring(0, 1).toUpperCase() + simpleProperty.substring(1);
                            method = currValueClass.getMethod(methodName, new Class[0]);
                            parameterArray = new Object[]{};
                        }
                        catch (NoSuchMethodException ignored) {
                            // empty catch block
                        }
                        if (method == null) {
                            try {
                                methodName = "is" + simpleProperty.substring(0, 1).toUpperCase() + simpleProperty.substring(1);
                                method = currValueClass.getMethod(methodName, new Class[0]);
                                parameterArray = new Object[]{};
                            }
                            catch (NoSuchMethodException ignored) {
                                // empty catch block
                            }
                        }
                        if (method == null) {
                            try {
                                methodName = "get";
                                method = currValueClass.getMethod(methodName, String.class);
                                parameterArray = new Object[]{simpleProperty};
                            }
                            catch (NoSuchMethodException ignored) {
                                // empty catch block
                            }
                        }
                        if (method == null) {
                            try {
                                methodName = "get";
                                method = currValueClass.getMethod(methodName, Object.class);
                                parameterArray = new Object[]{simpleProperty};
                            }
                            catch (NoSuchMethodException ignored) {
                                // empty catch block
                            }
                        }
                        if (method == null) {
                            throw new PropertyAccessException("No matching method found for property \"" + property + "\"");
                        }
                        currMethodCall = new MethodCall(method, parameterArray);
                    }
                    if (methodCall == null) {
                        methodCall = currMethodCall;
                    }
                    if (prevMethodCall != null) {
                        prevMethodCall.setNext(currMethodCall);
                    }
                    prevMethodCall = currMethodCall;
                    currValueClass = ((ChainedMethodCall)currMethodCall).getReturnType();
                } while (!parser.isFinished());
            }
            this.myMethods.put(lookup, methodCall);
            return methodCall;
        }
    }

    private Method findMethod(Class<?> theClass, String methodName, Class<?>[] paramTypes) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Method[] allMethods = theClass.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            Method method = allMethods[i];
            if (!methodName.equals(method.getName()) || !this.doesMethodApply(method, paramTypes)) continue;
            methods.add(method);
        }
        int size = methods.size();
        if (size == 1) {
            return (Method)methods.get(0);
        }
        if (size == 0) {
            return null;
        }
        Method mostSpecific = null;
        for (int i = 0; i < size; ++i) {
            Method method = (Method)methods.get(i);
            if (mostSpecific != null && !this.isMoreSpecific(method.getParameterTypes(), mostSpecific.getParameterTypes())) continue;
            mostSpecific = method;
        }
        return mostSpecific;
    }

    private void assignParameters(Class<?>[] desiredTypes, Object[] values) {
        for (int i = 0; i < desiredTypes.length; ++i) {
            Class<?> desiredType = desiredTypes[i];
            Class<?> valueType = values[i].getClass();
            if (desiredType == valueType) continue;
            if (!desiredType.isPrimitive()) {
                values[i] = desiredType.cast(values[i]);
                continue;
            }
            if (desiredType == Short.TYPE || desiredType == Short.class) {
                values[i] = ((Number)values[i]).shortValue();
                continue;
            }
            if (desiredType == Integer.TYPE || desiredType == Integer.class) {
                values[i] = ((Number)values[i]).intValue();
                continue;
            }
            if (desiredType == Long.TYPE || desiredType == Long.class) {
                values[i] = ((Number)values[i]).longValue();
                continue;
            }
            if (desiredType == Float.TYPE || desiredType == Float.class) {
                values[i] = Float.valueOf(((Number)values[i]).floatValue());
                continue;
            }
            if (desiredType != Double.TYPE && desiredType != Double.class) continue;
            values[i] = ((Number)values[i]).doubleValue();
        }
    }

    private boolean isMoreSpecific(Class<?>[] types1, Class<?>[] types2) {
        for (int i = 0; i < types1.length; ++i) {
            boolean leftParamAssignableToRight = this.isAssignable(types1[i], types2[i]);
            boolean rightParamAssignableToLeft = this.isAssignable(types2[i], types1[i]);
            if (leftParamAssignableToRight) {
                if (rightParamAssignableToLeft) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean doesMethodApply(Method method, Class<?>[] paramTypes) {
        Class<?>[] methodParamTypes = method.getParameterTypes();
        if (methodParamTypes.length != paramTypes.length) {
            return false;
        }
        for (int i = 0; i < methodParamTypes.length; ++i) {
            if (this.isAssignable(paramTypes[i], methodParamTypes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isAssignable(Class<?> fromClass, Class<?> toClass) {
        if (!toClass.isPrimitive() && toClass.isAssignableFrom(fromClass)) {
            return true;
        }
        if (toClass.isPrimitive()) {
            if (toClass == Boolean.TYPE && fromClass == Boolean.class) {
                return true;
            }
            if (toClass == Byte.TYPE && fromClass == Byte.class) {
                return true;
            }
            if (toClass == Short.TYPE && (fromClass == Short.class || fromClass == Byte.class)) {
                return true;
            }
            if (toClass == Integer.TYPE && (fromClass == Integer.class || fromClass == Short.class || fromClass == Byte.class)) {
                return true;
            }
            if (toClass == Long.TYPE && (fromClass == Long.class || fromClass == Integer.class || fromClass == Short.class || fromClass == Byte.class)) {
                return true;
            }
            if (toClass == Float.TYPE && (fromClass == Float.class || fromClass == Long.class || fromClass == Integer.class || fromClass == Short.class || fromClass == Byte.class)) {
                return true;
            }
            if (toClass == Float.TYPE && (fromClass == Double.class || fromClass == Float.class || fromClass == Long.class || fromClass == Integer.class || fromClass == Short.class || fromClass == Byte.class)) {
                return true;
            }
            if (toClass == Double.TYPE && (fromClass == Double.class || fromClass == Float.class || fromClass == Long.class || fromClass == Integer.class || fromClass == Short.class || fromClass == Byte.class)) {
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodDescriptor {
        private Class<?> myClass;
        private String myProperty;

        public MethodDescriptor(Class<?> clazz, String property) {
            if (clazz == null || property == null) {
                throw new IllegalArgumentException("Class or property being null not allowed!");
            }
            this.myClass = clazz;
            this.myProperty = property;
        }

        public int hashCode() {
            return 31 * this.myClass.hashCode() + this.myProperty.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MethodDescriptor)) {
                return false;
            }
            MethodDescriptor md = (MethodDescriptor)obj;
            return this.myClass == md.myClass && this.myProperty.equals(md.myProperty);
        }
    }
}

