/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jagg.AggregateFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FunctionCache<F extends AggregateFunction> {
    private final Map<String, List<F>> myAggregators = new HashMap<String, List<F>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public F getFunction(F archetype) {
        if (archetype == null) {
            return null;
        }
        AggregateFunction agg = null;
        Map<String, List<F>> map = this.myAggregators;
        synchronized (map) {
            if (!archetype.isInUse()) {
                archetype.setInUse(true);
                agg = (AggregateFunction)archetype;
            }
            if (agg == null) {
                List<F> aggsList = this.myAggregators.get(archetype.toString());
                if (aggsList != null) {
                    int size = aggsList.size();
                    for (int a = 0; a < size; ++a) {
                        AggregateFunction candidate = (AggregateFunction)aggsList.get(a);
                        if (candidate.isInUse()) continue;
                        agg = candidate;
                        agg.setInUse(true);
                        break;
                    }
                }
                if (aggsList == null) {
                    aggsList = new ArrayList<F>();
                    this.myAggregators.put(archetype.toString(), aggsList);
                }
                if (agg == null) {
                    agg = (AggregateFunction)this.replicate(archetype);
                    agg.setInUse(true);
                    aggsList.add(agg);
                }
            }
        }
        return (F)agg;
    }

    protected abstract F replicate(F var1);
}

