/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.util;

import java.util.Map;
import net.sf.jagg.math.DoubleDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrequencyMapUtil {
    private static final boolean DEBUG = false;

    public static <K> boolean add(Map<K, Integer> map, K key) {
        Integer frequency = map.get(key);
        if (frequency != null) {
            map.put(key, frequency + 1);
            return false;
        }
        map.put(key, 1);
        return true;
    }

    public static <K> boolean remove(Map<K, Integer> map, K key) {
        Integer frequency = map.get(key);
        if (frequency != null) {
            if (frequency > 1) {
                map.put(key, frequency - 1);
                return true;
            }
            map.remove(key);
            return false;
        }
        return false;
    }

    public static <K> void combine(Map<K, Integer> other, Map<K, Integer> into) {
        for (K c : other.keySet()) {
            Integer freq = into.get(c);
            if (freq != null) {
                into.put(c, freq + other.get(c));
                continue;
            }
            into.put(c, other.get(c));
        }
    }

    public static <K extends Number> DoubleDouble get(Map<K, Integer> map, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Invalid index: " + index);
        }
        int i = 0;
        for (Number key : map.keySet()) {
            int frequency = map.get(key);
            if ((i += frequency) <= index) continue;
            return new DoubleDouble(key.doubleValue());
        }
        throw new IndexOutOfBoundsException("Index too high: " + index);
    }

    public static <K extends Number> DoubleDouble get(Map<K, Integer> map, double index) {
        int ceiling;
        if (index < 0.0) {
            throw new IndexOutOfBoundsException("Invalid index: " + index);
        }
        int floor = (int)Math.floor(index);
        if (floor == (ceiling = (int)Math.ceil(index))) {
            return FrequencyMapUtil.get(map, floor);
        }
        int i = 0;
        DoubleDouble low = null;
        DoubleDouble high = null;
        for (Number key : map.keySet()) {
            if (low != null) {
                high = new DoubleDouble(key.doubleValue());
                break;
            }
            int frequency = map.get(key);
            if (!((double)(i += frequency) > index)) continue;
            low = new DoubleDouble(key.doubleValue());
            if (!((double)i > index + 1.0)) continue;
            return low;
        }
        if (low == null || high == null) {
            throw new IndexOutOfBoundsException("Index too high: " + index);
        }
        DoubleDouble temp = new DoubleDouble(index);
        temp.subtractFromSelf(floor);
        temp.multiplySelfBy(high);
        DoubleDouble temp2 = new DoubleDouble(index);
        temp2.negateSelf();
        temp2.addToSelf(ceiling);
        temp2.multiplySelfBy(low);
        temp2.addToSelf(temp);
        return temp2;
    }
}

