/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.util;

import java.util.Comparator;
import java.util.List;
import net.sf.jagg.exception.ExpectedComparableException;
import net.sf.jagg.model.AggregateValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateValuePropertiesComparator<T>
implements Comparator<AggregateValue<T>> {
    private List<String> myProperties;
    private int mySize;

    public AggregateValuePropertiesComparator(List<String> properties) {
        this.myProperties = properties;
        this.mySize = properties.size();
    }

    @Override
    public int compare(AggregateValue<T> av1, AggregateValue<T> av2) throws ExpectedComparableException {
        for (int i = 0; i < this.mySize; ++i) {
            String property = this.myProperties.get(i);
            Comparable value1 = (Comparable)av1.getPropertyValue(property);
            Comparable value2 = (Comparable)av2.getPropertyValue(property);
            try {
                int comp = value1 == null ? (value2 == null ? 0 : 1) : (value2 == null ? -1 : value1.compareTo(value2));
                if (comp == 0) continue;
                return comp;
            }
            catch (ClassCastException e) {
                throw new ExpectedComparableException("Property \"" + property + "\" needs to be Comparable.", e);
            }
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AggregateValuePropertiesComparator) {
            AggregateValuePropertiesComparator otherComp = (AggregateValuePropertiesComparator)obj;
            if (this.mySize != otherComp.mySize) {
                return false;
            }
            for (int i = 0; i < this.mySize; ++i) {
                if (this.myProperties.get(i).equals(otherComp.myProperties.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

