/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.msd;

import java.util.ArrayList;
import java.util.List;
import net.sf.jagg.model.ChainedMethodCall;
import net.sf.jagg.msd.ChainedDiscriminator;
import net.sf.jagg.msd.ChainedExtractor;
import net.sf.jagg.msd.Discriminator;
import net.sf.jagg.msd.Discriminators;
import net.sf.jagg.msd.Extractor;
import net.sf.jagg.msd.NullDiscriminator;
import net.sf.jagg.util.MethodCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesDiscriminator<T>
extends ChainedDiscriminator<T> {
    private List<ChainedMethodCall> myMethodCalls;
    private String[] myProperties;

    public PropertiesDiscriminator(String ... properties) {
        this.myProperties = properties;
        int numProperties = this.myProperties.length;
        this.myMethodCalls = new ArrayList<ChainedMethodCall>(numProperties);
    }

    public PropertiesDiscriminator(List<String> properties) {
        this.myProperties = new String[properties.size()];
        if (!properties.isEmpty()) {
            properties.toArray(this.myProperties);
        }
        int numProperties = this.myProperties.length;
        this.myMethodCalls = new ArrayList<ChainedMethodCall>(numProperties);
    }

    @Override
    protected <E> ChainedExtractor<E, ?, T> getChainedExtractor(List<E> elements, Extractor<E, T> extractor) {
        T obj = extractor.getLabel(elements.get(0));
        MethodCache cache = MethodCache.getMethodCache();
        for (int i = 0; i < this.myProperties.length; ++i) {
            String property = this.myProperties[i];
            this.myMethodCalls.add(cache.getMethodCallFromProperty(obj, property));
        }
        return new MethodCallChainedExtractor(extractor);
    }

    @Override
    protected <E> Discriminator<?> getDiscriminator(List<E> elements, ChainedExtractor<E, ?, T> extractor, int index) {
        if (index < this.myProperties.length) {
            ChainedMethodCall mc = this.myMethodCalls.get(index);
            Class<?> returnType = mc.getChainedReturnType();
            return Discriminators.getDiscriminator(returnType);
        }
        return new NullDiscriminator(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MethodCallChainedExtractor<E, L, B>
    extends ChainedExtractor<E, L, B> {
        public MethodCallChainedExtractor(Extractor<E, B> extractor) {
            super(extractor);
        }

        @Override
        public L getLabel(E element) {
            Object obj = this.myExtractor.getLabel(element);
            ChainedMethodCall mc = (ChainedMethodCall)PropertiesDiscriminator.this.myMethodCalls.get(this.myIndex);
            return (L)mc.invoke(obj);
        }

        @Override
        public boolean isComplete(E element) {
            return this.myExtractor.isComplete(element) || this.myIndex >= PropertiesDiscriminator.this.myProperties.length;
        }
    }
}

