/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.msd;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.RandomAccess;
import net.sf.jagg.msd.AbstractDiscriminator;
import net.sf.jagg.msd.ArrayDiscriminator;
import net.sf.jagg.msd.BigDecimalDiscriminator;
import net.sf.jagg.msd.BigIntegerDiscriminator;
import net.sf.jagg.msd.BooleanDiscriminator;
import net.sf.jagg.msd.ByteDiscriminator;
import net.sf.jagg.msd.CalendarDiscriminator;
import net.sf.jagg.msd.CharSequenceDiscriminator;
import net.sf.jagg.msd.CharacterDiscriminator;
import net.sf.jagg.msd.ClassDiscriminator;
import net.sf.jagg.msd.CollectionDiscriminator;
import net.sf.jagg.msd.DateDiscriminator;
import net.sf.jagg.msd.Discriminable;
import net.sf.jagg.msd.DiscriminableDiscriminator;
import net.sf.jagg.msd.Discriminator;
import net.sf.jagg.msd.DoubleDiscriminator;
import net.sf.jagg.msd.EnumDiscriminator;
import net.sf.jagg.msd.FloatDiscriminator;
import net.sf.jagg.msd.IntegerDiscriminator;
import net.sf.jagg.msd.LongDiscriminator;
import net.sf.jagg.msd.NullDiscriminator;
import net.sf.jagg.msd.RandomAccessListDiscriminator;
import net.sf.jagg.msd.ShortDiscriminator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Discriminators {
    private Discriminators() {
    }

    public static <T> Discriminator<T> getDiscriminator(T object) {
        AbstractDiscriminator discriminator;
        if (object instanceof Integer) {
            discriminator = new IntegerDiscriminator();
        } else if (object instanceof Double) {
            discriminator = new DoubleDiscriminator();
        } else if (object instanceof CharSequence) {
            discriminator = new CharSequenceDiscriminator();
        } else if (object instanceof Enum) {
            discriminator = new EnumDiscriminator();
        } else if (object instanceof Long) {
            discriminator = new LongDiscriminator();
        } else if (object instanceof Date) {
            discriminator = new DateDiscriminator();
        } else if (object instanceof Calendar) {
            discriminator = new CalendarDiscriminator();
        } else if (object instanceof Float) {
            discriminator = new FloatDiscriminator();
        } else if (object instanceof Short) {
            discriminator = new ShortDiscriminator();
        } else if (object instanceof Byte) {
            discriminator = new ByteDiscriminator();
        } else if (object instanceof Boolean) {
            discriminator = new BooleanDiscriminator();
        } else if (object instanceof Character) {
            discriminator = new CharacterDiscriminator();
        } else if (object instanceof BigInteger) {
            discriminator = new BigIntegerDiscriminator();
        } else if (object instanceof BigDecimal) {
            discriminator = new BigDecimalDiscriminator();
        } else if (object instanceof RandomAccess && object instanceof List) {
            discriminator = new RandomAccessListDiscriminator();
        } else if (object instanceof Collection) {
            discriminator = new CollectionDiscriminator();
        } else if (object instanceof Class) {
            discriminator = new ClassDiscriminator();
        } else if (object instanceof Object[]) {
            discriminator = new ArrayDiscriminator();
        } else if (object instanceof Discriminable) {
            discriminator = new DiscriminableDiscriminator();
        } else {
            return null;
        }
        return new NullDiscriminator<Integer>(discriminator);
    }

    public static <T> Discriminator<T> getDiscriminator(Class<T> c) {
        AbstractDiscriminator discriminator;
        if (Integer.class == c || Integer.TYPE == c) {
            discriminator = new IntegerDiscriminator();
        } else if (Double.class == c || Double.TYPE == c) {
            discriminator = new DoubleDiscriminator();
        } else if (CharSequence.class.isAssignableFrom(c)) {
            discriminator = new CharSequenceDiscriminator();
        } else if (Enum.class.isAssignableFrom(c)) {
            discriminator = new EnumDiscriminator();
        } else if (Long.class == c || Long.TYPE == c) {
            discriminator = new LongDiscriminator();
        } else if (Date.class.isAssignableFrom(c)) {
            discriminator = new DateDiscriminator();
        } else if (Calendar.class.isAssignableFrom(c)) {
            discriminator = new CalendarDiscriminator();
        } else if (Float.class == c || Float.TYPE == c) {
            discriminator = new FloatDiscriminator();
        } else if (Short.class == c || Short.TYPE == c) {
            discriminator = new ShortDiscriminator();
        } else if (Byte.class == c || Byte.TYPE == c) {
            discriminator = new ByteDiscriminator();
        } else if (Boolean.class == c || Boolean.TYPE == c) {
            discriminator = new BooleanDiscriminator();
        } else if (Character.class == c || Character.TYPE == c) {
            discriminator = new CharacterDiscriminator();
        } else if (BigInteger.class == c) {
            discriminator = new BigIntegerDiscriminator();
        } else if (BigDecimal.class == c) {
            discriminator = new BigDecimalDiscriminator();
        } else if (RandomAccess.class.isAssignableFrom(c) && List.class.isAssignableFrom(c)) {
            discriminator = new RandomAccessListDiscriminator();
        } else if (Collection.class.isAssignableFrom(c)) {
            discriminator = new CollectionDiscriminator();
        } else if (Class.class.isAssignableFrom(c)) {
            discriminator = new ClassDiscriminator();
        } else if (Object[].class.isAssignableFrom(c)) {
            discriminator = new ArrayDiscriminator();
        } else if (Discriminable.class.isAssignableFrom(c)) {
            discriminator = new DiscriminableDiscriminator();
        } else {
            return null;
        }
        return new NullDiscriminator<Integer>(discriminator);
    }

    public static <T> List<T> getFlattenedList(List<List<T>> listOfLists) {
        int size = 0;
        int numLists = listOfLists.size();
        for (int i = 0; i < numLists; ++i) {
            size += listOfLists.get(i).size();
        }
        ArrayList<T> flatList = new ArrayList<T>(size);
        for (int i = 0; i < numLists; ++i) {
            List<T> internalList = listOfLists.get(i);
            for (int j = 0; j < internalList.size(); ++j) {
                flatList.add(internalList.get(j));
            }
        }
        return flatList;
    }
}

