/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.msd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jagg.msd.ChainedDiscriminator;
import net.sf.jagg.msd.ChainedExtractor;
import net.sf.jagg.msd.Discriminator;
import net.sf.jagg.msd.Discriminators;
import net.sf.jagg.msd.Extractor;
import net.sf.jagg.msd.MsdWorkspace;
import net.sf.jagg.msd.NullDiscriminator;
import net.sf.jagg.msd.RandomAccessListDiscriminator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionDiscriminator<T>
extends ChainedDiscriminator<Collection<T>> {
    @Override
    public <E> List<List<E>> discriminate(List<E> elements, Extractor<E, Collection<T>> extractor, MsdWorkspace workspace) {
        RandomAccessListDiscriminator listDiscr = new RandomAccessListDiscriminator();
        ChainedExtractor<E, List<T>, Collection<T>> ce = this.getChainedExtractor(elements, extractor);
        return listDiscr.discriminate(elements, ce, workspace);
    }

    @Override
    protected <E> ChainedExtractor<E, List<T>, Collection<T>> getChainedExtractor(List<E> elements, Extractor<E, Collection<T>> extractor) {
        return new CollectionChainedExtractor<E, T>(extractor);
    }

    @Override
    protected <E> Discriminator<T> getDiscriminator(List<E> elements, ChainedExtractor<E, ?, Collection<T>> extractor, int index) {
        for (int i = 0; i < elements.size(); ++i) {
            List member;
            E element = elements.get(i);
            if (extractor.isComplete(element) || (member = (List)extractor.getLabel(element)) == null) continue;
            return Discriminators.getDiscriminator(member.getClass());
        }
        return new NullDiscriminator(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CollectionChainedExtractor<E, B>
    extends ChainedExtractor<E, List<B>, Collection<B>> {
        public CollectionChainedExtractor(Extractor<E, Collection<B>> extractor) {
            super(extractor);
        }

        @Override
        public List<B> getLabel(E element) {
            Collection collection = (Collection)this.myExtractor.getLabel(element);
            ArrayList list = new ArrayList();
            list.addAll(collection);
            return list;
        }

        @Override
        public boolean isComplete(E element) {
            return this.myExtractor.isComplete(element);
        }
    }
}

