/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.msd;

import java.util.ArrayList;
import java.util.List;
import net.sf.jagg.msd.AbstractDiscriminator;
import net.sf.jagg.msd.ChainedExtractor;
import net.sf.jagg.msd.Discriminator;
import net.sf.jagg.msd.Extractor;
import net.sf.jagg.msd.MsdWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChainedDiscriminator<T>
extends AbstractDiscriminator<T> {
    private static final boolean DEBUG = false;

    @Override
    public <E> List<List<E>> discriminate(List<E> elements, Extractor<E, T> extractor, MsdWorkspace workspace) {
        if (elements.size() == 0) {
            return new ArrayList<List<E>>(0);
        }
        ArrayList<List<E>> curr = new ArrayList<List<E>>(1);
        curr.add(elements);
        ArrayList results = new ArrayList();
        ChainedExtractor chainedExtractor = this.getChainedExtractor(elements, extractor);
        int index = 0;
        while (!curr.isEmpty()) {
            Discriminator<?> discr = this.getDiscriminator(elements, chainedExtractor, index);
            if (discr == null) {
                return null;
            }
            ArrayList next = new ArrayList();
            chainedExtractor.setIndex(index);
            for (int i = 0; i < curr.size(); ++i) {
                int j;
                List currElements = (List)curr.get(i);
                ArrayList finished = new ArrayList();
                ArrayList remaining = new ArrayList();
                for (j = 0; j < currElements.size(); ++j) {
                    Object element = currElements.get(j);
                    if (chainedExtractor.isComplete(element)) {
                        finished.add(element);
                        continue;
                    }
                    remaining.add(element);
                }
                List equivClasses = discr.discriminate(remaining, chainedExtractor, workspace);
                if (!finished.isEmpty()) {
                    results.add(finished);
                }
                if (equivClasses.size() == 1 && chainedExtractor.isAllComplete()) {
                    results.add(equivClasses.get(0));
                    continue;
                }
                for (j = 0; j < equivClasses.size(); ++j) {
                    List equivClass = equivClasses.get(j);
                    if (equivClass.size() > 1) {
                        next.add(equivClass);
                        continue;
                    }
                    results.add(equivClass);
                }
            }
            curr = next;
            ++index;
        }
        int size = curr.size();
        for (int i = 0; i < size; ++i) {
            results.add(curr.get(i));
        }
        return results;
    }

    protected abstract <E> ChainedExtractor<E, ?, T> getChainedExtractor(List<E> var1, Extractor<E, T> var2);

    protected abstract <E> Discriminator<?> getDiscriminator(List<E> var1, ChainedExtractor<E, ?, T> var2, int var3);
}

