/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.msd;

import java.util.ArrayList;
import java.util.List;
import net.sf.jagg.msd.AbstractDiscriminator;
import net.sf.jagg.msd.Extractor;
import net.sf.jagg.msd.MsdWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanDiscriminator
extends AbstractDiscriminator<Boolean> {
    @Override
    public <E> List<List<E>> discriminate(List<E> elements, Extractor<E, Boolean> extractor, MsdWorkspace workspace) {
        ArrayList<E> trues = new ArrayList<E>();
        ArrayList<E> falses = new ArrayList<E>();
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            E element = elements.get(i);
            if (extractor.getLabel(element).booleanValue()) {
                trues.add(element);
                continue;
            }
            falses.add(element);
        }
        ArrayList<List<ArrayList<E>>> equivClasses = new ArrayList<List<ArrayList<E>>>();
        if (!trues.isEmpty()) {
            equivClasses.add(trues);
        }
        if (!falses.isEmpty()) {
            equivClasses.add(falses);
        }
        return equivClasses;
    }
}

