/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.model;

public class WindowClause {
    public static final WindowClause DEFAULT = new WindowClause(Type.RANGE, null, 0);
    private Type myWindowType;
    private Number myStartValue;
    private Number myEndValue;

    public WindowClause(Type windowType, Number startValue, Number endValue) {
        if (windowType == null) {
            throw new IllegalArgumentException("windowType must not be null!");
        }
        this.myWindowType = windowType;
        this.myStartValue = startValue;
        this.myEndValue = endValue;
    }

    public Type getWindowType() {
        return this.myWindowType;
    }

    public Number getStartValue() {
        return this.myStartValue;
    }

    public Number getEndValue() {
        return this.myEndValue;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.myWindowType.toString());
        buf.append("(");
        if (this.myStartValue != null) {
            buf.append(this.myStartValue);
        }
        buf.append(", ");
        if (this.myEndValue != null) {
            buf.append(this.myEndValue);
        }
        buf.append(")");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ROWS,
        RANGE;

    }
}

