/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.model;

import java.util.ArrayList;
import java.util.List;
import net.sf.jagg.AggregateFunction;
import net.sf.jagg.model.AggregateValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionedAggregatorList<T> {
    private int myPos;
    private T myInitialObject = null;
    private List<AggregateFunction> myInitialAggList = null;
    private List<AggregateValue<T>> myMiddleAggValues = new ArrayList<AggregateValue<T>>();
    private T myEndingObject = null;
    private List<AggregateFunction> myEndingAggList = null;

    public PositionedAggregatorList(int pos) {
        this.myPos = pos;
    }

    public void setInitialList(T initObject, List<AggregateFunction> initAggregators) {
        this.myInitialObject = initObject;
        this.myInitialAggList = initAggregators;
    }

    public void setMiddleAggValues(List<AggregateValue<T>> aggValues) {
        this.myMiddleAggValues.addAll(aggValues);
    }

    public void setEndingList(T endingObject, List<AggregateFunction> endingAggregators) {
        this.myEndingObject = endingObject;
        this.myEndingAggList = endingAggregators;
    }

    public int getPosition() {
        return this.myPos;
    }

    public T getInitialObject() {
        return this.myInitialObject;
    }

    public List<AggregateFunction> getInitialAggList() {
        return this.myInitialAggList;
    }

    public List<AggregateValue<T>> getMiddleAggValues() {
        return this.myMiddleAggValues;
    }

    public T getEndingObject() {
        return this.myEndingObject;
    }

    public List<AggregateFunction> getEndingAggList() {
        return this.myEndingAggList;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("PAL: pos=");
        buf.append(this.myPos);
        buf.append("\n  Initial object=");
        buf.append(this.myInitialObject == null ? "(null)" : this.myInitialObject.toString());
        for (int i = 0; i < this.myMiddleAggValues.size(); ++i) {
            buf.append("\n  MiddleAggValue object(");
            buf.append(i);
            buf.append(")=");
            buf.append(this.myMiddleAggValues.get(i).toString());
        }
        buf.append("\n  Ending object=");
        buf.append(this.myEndingObject == null ? "(null)" : this.myEndingObject.toString());
        return buf.toString();
    }
}

