/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.model;

public class OrderByElement {
    private String myProperty;
    private SortDir mySortDir;
    private NullSort myNullSort;

    public OrderByElement(String property) {
        this(property, SortDir.ASC, NullSort.LAST);
    }

    public OrderByElement(String property, SortDir sortDir) {
        this(property, sortDir, sortDir == SortDir.ASC ? NullSort.LAST : NullSort.FIRST);
    }

    public OrderByElement(String property, NullSort nullSort) {
        this(property, SortDir.ASC, nullSort);
    }

    public OrderByElement(String property, SortDir sortDir, NullSort nullSort) {
        this.myProperty = property;
        this.mySortDir = sortDir;
        this.myNullSort = nullSort;
    }

    public String getProperty() {
        return this.myProperty;
    }

    public SortDir getSortDir() {
        return this.mySortDir;
    }

    public NullSort getNullSort() {
        return this.myNullSort;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof OrderByElement) {
            OrderByElement obe = (OrderByElement)obj;
            return this.myProperty.equals(obe.myProperty) && this.mySortDir == obe.mySortDir && this.myNullSort == obe.myNullSort;
        }
        return false;
    }

    public int hashCode() {
        int hc = this.myProperty.hashCode();
        hc += 31 * hc + this.mySortDir.hashCode();
        hc += 31 * hc + this.myNullSort.hashCode();
        return hc;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.myProperty);
        buf.append(" ");
        buf.append((Object)this.mySortDir);
        buf.append(" ");
        buf.append((Object)this.myNullSort);
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NullSort {
        FIRST,
        LAST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortDir {
        ASC,
        DESC;

    }
}

