/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.model;

import java.util.List;
import net.sf.jagg.model.AnalyticValue;
import net.sf.jagg.util.PartitionAndOrderByComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticContext<T> {
    private List<AnalyticValue<T>> mySortedValues;
    private PartitionAndOrderByComparator<T> myComparator;
    private List<Integer> myDependencies;
    private int myWindowStartIndex;
    private int myWindowEndIndex;
    private int myTerminatedThroughIndex;
    private int myEndPartitionIndex;

    public AnalyticContext(List<AnalyticValue<T>> sortedValues, PartitionAndOrderByComparator<T> comparator) {
        this.mySortedValues = sortedValues;
        this.myComparator = comparator;
        this.myDependencies = null;
        this.myWindowStartIndex = 0;
        this.myWindowEndIndex = -1;
        this.myTerminatedThroughIndex = -1;
        this.myEndPartitionIndex = -1;
    }

    public List<AnalyticValue<T>> getListOfValues() {
        return this.mySortedValues;
    }

    public PartitionAndOrderByComparator<T> getComparator() {
        return this.myComparator;
    }

    public List<Integer> getDependencies() {
        return this.myDependencies;
    }

    public void setDependencies(List<Integer> dependencies) {
        this.myDependencies = dependencies;
    }

    public int getWindowStartIndex() {
        return this.myWindowStartIndex;
    }

    public void incrementWindowStartIndex() {
        ++this.myWindowStartIndex;
    }

    public void advanceWindowStartPastLastTerminated() {
        this.myWindowStartIndex = this.myTerminatedThroughIndex + 1;
    }

    public int getWindowEndIndex() {
        return this.myWindowEndIndex;
    }

    public void incrementWindowEndIndex() {
        ++this.myWindowEndIndex;
    }

    public boolean isWindowEmpty() {
        return this.myWindowStartIndex > this.myWindowEndIndex;
    }

    public int getTerminatedThroughIndex() {
        return this.myTerminatedThroughIndex;
    }

    public void incrementTerminatedThroughIndex() {
        ++this.myTerminatedThroughIndex;
    }

    public int getEndOfPartitionIndex() {
        return this.myEndPartitionIndex;
    }

    public void setEndOfPartitionIndex(int index) {
        this.myEndPartitionIndex = index;
    }
}

