/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jagg.AggregateFunction;
import net.sf.jagg.Aggregator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateValue<T> {
    private T myObject;
    private Map<AggregateFunction, Object> myValuesMap;
    private List<Object> myValuesList;
    private List<AggregateFunction> myAggregators;
    private List<String> myProperties;
    private List<Integer> myGroupingSet;

    public AggregateValue(T object) {
        this.myObject = object;
        this.myValuesMap = new HashMap<AggregateFunction, Object>();
        this.myValuesList = new ArrayList<Object>();
        this.myAggregators = null;
    }

    public AggregateValue(AggregateValue<T> other) {
        this(other.myObject);
    }

    public T getObject() {
        return this.myObject;
    }

    public Object getPropertyValue(String property) {
        int index;
        if (this.myObject == null) {
            return null;
        }
        if (this.myProperties != null && !this.myGroupingSet.contains(index = this.myProperties.indexOf(property))) {
            return null;
        }
        return Aggregator.getValueFromProperty(this.myObject, property);
    }

    public Object getPropertyValue(int propIndex) {
        if (this.myProperties != null && this.myObject != null) {
            return this.getPropertyValue(this.myProperties.get(propIndex));
        }
        return null;
    }

    public void setAggregateValue(AggregateFunction agg, Object value) {
        this.myValuesMap.put(agg, value);
        this.myValuesList.add(value);
    }

    public Object getAggregateValue(AggregateFunction agg) {
        return this.myValuesMap.get(agg);
    }

    public Object getAggregateValue(int index) {
        return this.myValuesList.get(index);
    }

    public boolean isGrouping(int field) {
        if (field < 0 || field >= this.myProperties.size()) {
            throw new IllegalArgumentException("isGrouping: integer field reference out of range: " + field);
        }
        return !this.myGroupingSet.contains(field);
    }

    public boolean isGrouping(String propertyName) {
        int index = this.myProperties.indexOf(propertyName);
        if (index == -1) {
            try {
                index = Integer.parseInt(propertyName);
                return this.isGrouping(index);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("isGrouping: Not a group-by property name or an integer field reference: " + propertyName);
            }
        }
        return this.isGrouping(this.myProperties.indexOf(propertyName));
    }

    public int getGroupingId(List<?> fields) {
        int groupingId = 0;
        for (Object field : fields) {
            int fieldRef;
            groupingId <<= 1;
            if (field instanceof Number) {
                fieldRef = ((Number)field).intValue();
            } else {
                String propertyName = field.toString();
                fieldRef = this.myProperties.indexOf(propertyName);
                if (fieldRef == -1) {
                    try {
                        fieldRef = Integer.parseInt(propertyName);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("getGroupingId: Not a group-by property name or an integer field reference: " + propertyName);
                    }
                }
            }
            if (fieldRef < 0 || fieldRef >= this.myProperties.size()) {
                throw new IllegalArgumentException("getGroupingId: integer field reference out of range: " + field);
            }
            if (!this.isGrouping(fieldRef)) continue;
            groupingId |= 1;
        }
        return groupingId;
    }

    public void assignAggregators(List<AggregateFunction> aggs) {
        this.myAggregators = aggs;
    }

    public List<AggregateFunction> retrieveAggregators() {
        return this.myAggregators;
    }

    public void releaseAggregators() {
        for (AggregateFunction agg : this.myAggregators) {
            agg.setInUse(false);
        }
        this.myAggregators.clear();
    }

    public void assignPropsAndGroupingSet(List<String> properties, List<Integer> groupingSet) {
        this.myProperties = properties;
        this.myGroupingSet = groupingSet;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("AggregateValue:(object => ");
        buf.append(this.myObject.toString());
        buf.append(", valuesList =>");
        buf.append(this.myValuesList.toString());
        buf.append(", aggregators =>");
        buf.append(this.myAggregators.toString());
        buf.append(", properties =>");
        buf.append(this.myProperties.toString());
        buf.append(", groupingSet =>");
        buf.append(this.myGroupingSet.toString());
        buf.append(")");
        return buf.toString();
    }
}

