/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.math;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class DoubleDouble
implements Comparable<DoubleDouble> {
    public static final DoubleDouble NaN = new ImmutableDoubleDouble(Double.NaN, 0.0);
    public static final DoubleDouble ZERO = new ImmutableDoubleDouble();
    private static final double SPLIT = 1.34217729E8;
    private double myHigh;
    private double myLow;

    public DoubleDouble() {
        this.myHigh = 0.0;
        this.myLow = 0.0;
    }

    public DoubleDouble(double d) {
        this.myHigh = d;
        this.myLow = 0.0;
    }

    public DoubleDouble(double hi, double lo) {
        this.normalize(hi, lo, 0.0);
    }

    public DoubleDouble(DoubleDouble dd) {
        this.myHigh = dd.myHigh;
        this.myLow = dd.myLow;
    }

    public void reset() {
        this.myHigh = 0.0;
        this.myLow = 0.0;
    }

    public double doubleValue() {
        return this.myHigh;
    }

    public double getLow() {
        return this.myLow;
    }

    public boolean isNaN() {
        return Double.isNaN(this.myHigh);
    }

    public void addToSelf(DoubleDouble dd) {
        if (this.isNaN()) {
            return;
        }
        double s0 = this.myHigh + dd.myHigh;
        double v = s0 - this.myHigh;
        double e = this.myHigh - (s0 - v) + (dd.myHigh - v);
        double f = this.myLow + dd.myLow;
        v = f - this.myLow;
        double e2 = this.myLow - (f - v) + (dd.myLow - v);
        double s1 = f + e;
        v = s1 - f;
        double e3 = f - (s1 - v) + (e - v);
        e = e2 + e3;
        this.normalize(s0, s1, e);
    }

    public void addToSelf(double d) {
        if (this.isNaN()) {
            return;
        }
        double s0 = this.myHigh + d;
        double v = s0 - this.myHigh;
        double e = this.myHigh - (s0 - v) + (d - v);
        double s1 = this.myLow + e;
        v = s1 - this.myLow;
        e = this.myLow - (s1 - v) + (e - v);
        this.normalize(s0, s1, e);
    }

    public void subtractFromSelf(DoubleDouble dd) {
        DoubleDouble negative = new DoubleDouble(dd);
        negative.negateSelf();
        this.addToSelf(negative);
    }

    public void subtractFromSelf(double d) {
        this.addToSelf(-d);
    }

    public void negateSelf() {
        this.myHigh = -this.myHigh;
        this.myLow = -this.myLow;
    }

    public void multiplySelfBy(DoubleDouble dd) {
        if (this.isNaN()) {
            return;
        }
        double p0 = this.myHigh * dd.myHigh;
        double v = 1.34217729E8 * this.myHigh;
        double ah = v - (v - this.myHigh);
        double al = this.myHigh - ah;
        v = 1.34217729E8 * dd.myHigh;
        double bh = v - (v - dd.myHigh);
        double bl = dd.myHigh - bh;
        double e0 = ah * bh - p0 + ah * bl + al * bh + al * bl;
        double p1 = this.myHigh * dd.myLow;
        double ch = bh;
        double cl = bl;
        v = 1.34217729E8 * dd.myLow;
        bh = v - (v - dd.myLow);
        bl = dd.myLow - bh;
        double e1 = ah * bh - p1 + ah * bl + al * bh + al * bl;
        double p2 = this.myLow * dd.myHigh;
        v = 1.34217729E8 * this.myLow;
        ah = v - (v - this.myLow);
        al = this.myLow - ah;
        double e2 = ah * ch - p2 + ah * cl + al * ch + al * cl;
        bh = e0 + p1;
        v = bh - e0;
        bl = e0 - (bh - v) + (p1 - v);
        p1 = bh + p2;
        v = p1 - bh;
        e0 = bh - (p1 - v) + (p2 - v);
        this.normalize(p0, p1, e0 += bl + this.myLow * dd.myLow + e1 + e2);
    }

    public void multiplySelfBy(double d) {
        if (this.isNaN()) {
            return;
        }
        double p0 = this.myHigh * d;
        double v = 1.34217729E8 * this.myHigh;
        double ah = v - (v - this.myHigh);
        double al = this.myHigh - ah;
        v = 1.34217729E8 * d;
        double bh = v - (v - d);
        double bl = d - bh;
        double e = ah * bh - p0 + ah * bl + al * bh + al * bl;
        double f = this.myLow * d;
        v = 1.34217729E8 * this.myLow;
        ah = v - (v - this.myLow);
        al = this.myLow - ah;
        double e2 = ah * bh - f + ah * bl + al * bh + al * bl;
        double p1 = e + f;
        v = p1 - e;
        e = e - (p1 - v) + (f - v);
        this.normalize(p0, p1, e += e2);
    }

    public void squareSelf() {
        if (this.isNaN()) {
            return;
        }
        double p0 = this.myHigh * this.myHigh;
        double v = 1.34217729E8 * this.myHigh;
        double ah = v - (v - this.myHigh);
        double al = this.myHigh - ah;
        double e0 = ah * ah - p0 + ah * al + al * ah + al * al;
        double p1 = this.myHigh * this.myLow;
        v = 1.34217729E8 * this.myLow;
        double bh = v - (v - this.myLow);
        double bl = this.myLow - bh;
        double e1 = ah * bh - p1 + ah * bl + al * bh + al * bl;
        bh = e0 + (p1 *= 2.0);
        v = bh - e0;
        bl = e0 - (bh - v) + (p1 - v);
        this.normalize(p0, bh, bl += this.myLow * this.myLow + (e1 *= 2.0));
    }

    public void divideSelfBy(DoubleDouble dd) {
        double x = 1.0 / dd.myHigh;
        double y = this.myHigh * x;
        DoubleDouble r = new DoubleDouble(dd);
        r.multiplySelfBy(y);
        r.negateSelf();
        r.addToSelf(this);
        r.multiplySelfBy(x);
        r.addToSelf(y);
        this.myHigh = r.myHigh;
        this.myLow = r.myLow;
    }

    public void divideSelfBy(double d) {
        double x = 1.0 / d;
        double y = this.myHigh * x;
        DoubleDouble r = new DoubleDouble(d);
        r.multiplySelfBy(y);
        r.negateSelf();
        r.addToSelf(this);
        r.multiplySelfBy(x);
        r.addToSelf(y);
        this.myHigh = r.myHigh;
        this.myLow = r.myLow;
    }

    public void sqrtSelf() {
        double x = 1.0 / Math.sqrt(this.myHigh);
        double y = this.myHigh * x;
        DoubleDouble r = new DoubleDouble(y);
        r.squareSelf();
        r.negateSelf();
        r.addToSelf(this);
        r.multiplySelfBy(x);
        r.divideSelfBy(2.0);
        r.addToSelf(y);
        this.myHigh = r.myHigh;
        this.myLow = r.myLow;
    }

    public void powSelf(long exponent) {
        if (this.isNaN()) {
            return;
        }
        if (exponent == 0L) {
            if (this.myHigh == 0.0) {
                this.myHigh = Double.NaN;
                this.myLow = 0.0;
            } else {
                this.myHigh = 1.0;
                this.myLow = 0.0;
            }
        }
        if (this.myHigh == 0.0 || this.myHigh == 1.0 && this.myLow == 0.0) {
            return;
        }
        boolean invert = exponent < 0L;
        if ((exponent = Math.abs(exponent)) == 2L) {
            this.squareSelf();
        } else if (exponent > 2L) {
            DoubleDouble result = new DoubleDouble(1.0);
            DoubleDouble square = new DoubleDouble(this);
            while (exponent >= 1L) {
                if ((exponent & 1L) == 1L) {
                    result.multiplySelfBy(square);
                }
                square.squareSelf();
                exponent >>>= 1;
            }
            this.myHigh = result.myHigh;
            this.myLow = result.myLow;
        }
        if (invert) {
            DoubleDouble reciprocal = new DoubleDouble(1.0);
            reciprocal.divideSelfBy(this);
            this.myHigh = reciprocal.myHigh;
            this.myLow = reciprocal.myLow;
        }
    }

    public void nthRootSelf(long n) {
        double x = Math.pow(this.myHigh, (1.0 - (double)n) / (double)n);
        double y = this.myHigh * x;
        DoubleDouble r = new DoubleDouble(y);
        r.powSelf(n);
        r.negateSelf();
        r.addToSelf(this);
        r.multiplySelfBy(x);
        r.divideSelfBy(n);
        r.addToSelf(y);
        this.myHigh = r.myHigh;
        this.myLow = r.myLow;
    }

    private void normalize(double s0, double s1, double e) {
        int k = 0;
        double v = s1 + e;
        double t2 = e - (v - s1);
        double t0 = s0 + v;
        double t1 = v - (t0 - s0);
        this.myLow = 0.0;
        this.myHigh = 0.0;
        v = t0 + t1;
        e = t1 - (v - t0);
        if (v != 0.0) {
            this.myHigh = v;
            this.myLow = 0.0;
            v = e;
            ++k;
        }
        if ((s0 = v + t2) != 0.0) {
            if (k == 0) {
                this.myHigh = s0;
                this.myLow = t2 - (s0 - v);
            } else {
                this.myLow = s0;
            }
        }
    }

    @Override
    public int compareTo(DoubleDouble other) {
        if (this.myHigh < other.myHigh) {
            return -1;
        }
        if (this.myHigh > other.myHigh) {
            return 1;
        }
        if (this.myLow < other.myLow) {
            return -1;
        }
        if (this.myLow > other.myLow) {
            return 1;
        }
        return 0;
    }

    private strictfp static class ImmutableDoubleDouble
    extends DoubleDouble {
        public ImmutableDoubleDouble() {
            super(0.0, 0.0);
        }

        public ImmutableDoubleDouble(double hi, double lo) {
            super(hi, lo);
        }

        public void addToSelf(DoubleDouble dd) {
            this.notSupported();
        }

        public void addToSelf(double d) {
            this.notSupported();
        }

        public void divideSelfBy(DoubleDouble dd) {
            this.notSupported();
        }

        public void divideSelfBy(double d) {
            this.notSupported();
        }

        public void multiplySelfBy(DoubleDouble dd) {
            this.notSupported();
        }

        public void multiplySelfBy(double d) {
            this.notSupported();
        }

        public void negateSelf() {
            this.notSupported();
        }

        public void nthRootSelf(long n) {
            this.notSupported();
        }

        public void powSelf(long n) {
            this.notSupported();
        }

        public void reset() {
            this.notSupported();
        }

        public void sqrtSelf() {
            this.notSupported();
        }

        public void squareSelf() {
            this.notSupported();
        }

        public void subtractFromSelf(DoubleDouble dd) {
            this.notSupported();
        }

        public void subtractFromSelf(double d) {
            this.notSupported();
        }

        private void notSupported() {
            throw new UnsupportedOperationException("Can't modify constant DoubleDouble value.");
        }
    }
}

