/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.AggregateFunction;
import net.sf.jagg.NoPropAnalytic;
import net.sf.jagg.model.WindowClause;

public class RowNumberAnalytic
extends NoPropAnalytic {
    private long myCount;

    public RowNumberAnalytic(String property) {
        this.setProperty(property);
    }

    public RowNumberAnalytic() {
        this.setProperty(null);
    }

    public RowNumberAnalytic replicate() {
        return new RowNumberAnalytic();
    }

    public void init() {
        this.myCount = 0L;
    }

    public void iterate(Object value) {
        if (value != null) {
            ++this.myCount;
        }
    }

    public void delete(Object value) {
        if (value != null) {
            --this.myCount;
        }
    }

    public boolean takesWindowClause() {
        return false;
    }

    public WindowClause getWindowClause() {
        return new WindowClause(WindowClause.Type.ROWS, null, 0);
    }

    public void merge(AggregateFunction agg) {
        if (agg != null && agg instanceof RowNumberAnalytic) {
            RowNumberAnalytic otherAna = (RowNumberAnalytic)agg;
            this.myCount += otherAna.myCount;
        }
    }

    public Long terminate() {
        return this.myCount;
    }
}

