/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.AggregateFunction;
import net.sf.jagg.NoPropAnalytic;
import net.sf.jagg.model.WindowClause;

public class RankAnalytic
extends NoPropAnalytic {
    private long myCount;
    private long myRun;
    private boolean doIStartRunOver;

    public RankAnalytic(String property) {
        this.setProperty(property);
    }

    public RankAnalytic() {
        this.setProperty(null);
    }

    public RankAnalytic replicate() {
        return new RankAnalytic();
    }

    public void init() {
        this.myCount = 0L;
        this.myRun = 0L;
        this.doIStartRunOver = false;
    }

    public void iterate(Object value) {
        if (value != null) {
            ++this.myCount;
            this.myRun = this.doIStartRunOver ? 1L : ++this.myRun;
            this.doIStartRunOver = false;
        }
    }

    public void delete(Object value) {
        if (value != null) {
            this.doIStartRunOver = true;
        }
    }

    public boolean takesWindowClause() {
        return false;
    }

    public WindowClause getWindowClause() {
        return new WindowClause(WindowClause.Type.RANGE, 0, 0);
    }

    public void merge(AggregateFunction agg) {
        throw new UnsupportedOperationException("Merge not implemented!");
    }

    public Long terminate() {
        return this.myCount + 1L - this.myRun;
    }
}

