/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.AggregateFunction;
import net.sf.jagg.Aggregator;
import net.sf.jagg.AnalyticFunction;
import net.sf.jagg.exception.ExpectedNumberException;
import net.sf.jagg.math.DoubleDouble;
import net.sf.jagg.model.WindowClause;

public class ProductAggregator
extends Aggregator
implements AnalyticFunction {
    private DoubleDouble myProduct = new DoubleDouble();
    private int myNumZeroes = 0;

    public ProductAggregator(String property) {
        this.setProperty(property);
    }

    public ProductAggregator replicate() {
        return new ProductAggregator(this.getProperty());
    }

    public void init() {
        this.myProduct.reset();
        this.myProduct.addToSelf(1.0);
        this.myNumZeroes = 0;
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Number obj = (Number)ProductAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    double d = obj.doubleValue();
                    if (d == 0.0) {
                        ++this.myNumZeroes;
                    } else {
                        this.myProduct.multiplySelfBy(d);
                    }
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedNumberException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public void delete(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Number obj = (Number)ProductAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    if (obj.doubleValue() == 0.0) {
                        --this.myNumZeroes;
                    } else {
                        this.myProduct.divideSelfBy(obj.doubleValue());
                    }
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedNumberException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public boolean takesWindowClause() {
        return true;
    }

    public WindowClause getWindowClause() {
        return null;
    }

    public void merge(AggregateFunction agg) {
        if (agg != null && agg instanceof ProductAggregator) {
            ProductAggregator otherAgg = (ProductAggregator)agg;
            this.myProduct.multiplySelfBy(otherAgg.myProduct);
            this.myNumZeroes += otherAgg.myNumZeroes;
        }
    }

    public Double terminate() {
        return this.terminateDoubleDouble().doubleValue();
    }

    public DoubleDouble terminateDoubleDouble() {
        if (this.myNumZeroes > 0) {
            return new DoubleDouble(0.0);
        }
        return new DoubleDouble(this.myProduct);
    }
}

