/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.util.TreeMap;
import net.sf.jagg.AggregateFunction;
import net.sf.jagg.AnalyticFunction;
import net.sf.jagg.TwoPropAggregator;
import net.sf.jagg.exception.ExpectedNumberException;
import net.sf.jagg.math.DoubleDouble;
import net.sf.jagg.model.WindowClause;
import net.sf.jagg.util.FrequencyMapUtil;

public class PercentileAggregator
extends TwoPropAggregator
implements AnalyticFunction {
    private TreeMap<Double, Integer> myIteratedElements;
    private double myPercentile;

    public PercentileAggregator(String properties) {
        this.setProperty(properties);
    }

    public PercentileAggregator(double percentile, String property) {
        this.setProperty("" + percentile + "," + property);
    }

    public PercentileAggregator replicate() {
        return new PercentileAggregator(this.myPercentile, this.getProperty2());
    }

    protected void setProperty(String property) {
        super.setProperty(property);
        try {
            this.myPercentile = Double.parseDouble(this.getProperty());
            if (this.myPercentile < 0.0 || this.myPercentile > 1.0) {
                throw new ExpectedNumberException("First property (percentile) must be between 0 and 1 inclusive: " + this.myPercentile);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("First property (percentile) must be between 0 and 1 inclusive: " + this.myPercentile, e);
        }
        if (this.getProperty2() == null) {
            throw new IllegalArgumentException("Second property (sort parameter) must not be null.");
        }
    }

    public void init() {
        this.myIteratedElements = new TreeMap();
    }

    public boolean takesWindowClause() {
        return true;
    }

    public WindowClause getWindowClause() {
        return null;
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty2();
            try {
                Number obj = (Number)PercentileAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    Double d = obj.doubleValue();
                    FrequencyMapUtil.add(this.myIteratedElements, d);
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedNumberException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public void delete(Object value) {
        if (value != null) {
            String property = this.getProperty2();
            try {
                Number obj = (Number)PercentileAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    Double d = obj.doubleValue();
                    FrequencyMapUtil.remove(this.myIteratedElements, d);
                }
            }
            catch (ClassCastException e) {
                throw new ExpectedNumberException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public void merge(AggregateFunction agg) {
        if (agg != null && agg instanceof PercentileAggregator) {
            PercentileAggregator otherAgg = (PercentileAggregator)agg;
            FrequencyMapUtil.combine(otherAgg.myIteratedElements, this.myIteratedElements);
        }
    }

    public Double terminate() {
        return this.terminateDoubleDouble().doubleValue();
    }

    public DoubleDouble terminateDoubleDouble() {
        int numItems = this.myIteratedElements.size();
        DoubleDouble rownum = new DoubleDouble(this.myPercentile);
        rownum.multiplySelfBy(numItems - 1);
        double floor = Math.floor(rownum.doubleValue());
        double ceiling = Math.ceil(rownum.doubleValue());
        if (numItems == 0) {
            return new DoubleDouble(DoubleDouble.NaN);
        }
        if (rownum.doubleValue() == floor && rownum.doubleValue() == ceiling) {
            return FrequencyMapUtil.get(this.myIteratedElements, (int)floor);
        }
        return FrequencyMapUtil.get(this.myIteratedElements, rownum.doubleValue());
    }
}

