/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.AbstractDependentAnalyticFunction;
import net.sf.jagg.AnalyticFunction;
import net.sf.jagg.CountAggregator;
import net.sf.jagg.RankAnalytic;
import net.sf.jagg.math.DoubleDouble;
import net.sf.jagg.model.WindowClause;

public class PercentRankAnalytic
extends AbstractDependentAnalyticFunction {
    public PercentRankAnalytic(String property) {
        this.setProperty(property);
    }

    public PercentRankAnalytic() {
        this.setProperty(null);
    }

    public PercentRankAnalytic replicate() {
        return new PercentRankAnalytic();
    }

    public int getNumDependentFunctions() {
        return 2;
    }

    public AnalyticFunction getAnalyticFunction(int index) {
        switch (index) {
            case 0: {
                return new RankAnalytic();
            }
            case 1: {
                return new CountAggregator("*");
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index);
    }

    public WindowClause getWindowClause(int index) {
        switch (index) {
            case 0: {
                return null;
            }
            case 1: {
                return new WindowClause(WindowClause.Type.RANGE, null, null);
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index);
    }

    public Double terminate() {
        return this.terminateDoubleDouble().doubleValue();
    }

    public DoubleDouble terminateDoubleDouble() {
        Long value1 = (Long)this.getValue(1);
        if (value1 == 0L) {
            return new DoubleDouble();
        }
        DoubleDouble result = new DoubleDouble((Long)this.getValue(0) - 1L);
        result.divideSelfBy(value1 - 1L);
        return result;
    }
}

