/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.AbstractDependentAnalyticFunction;
import net.sf.jagg.AnalyticFunction;
import net.sf.jagg.CountAggregator;
import net.sf.jagg.exception.ExpectedNumberException;
import net.sf.jagg.model.WindowClause;

public class NtileAnalytic
extends AbstractDependentAnalyticFunction {
    private int myN;

    public NtileAnalytic(String property) {
        this.setProperty(property);
    }

    protected void setProperty(String property) {
        super.setProperty(property);
        try {
            this.myN = Integer.parseInt(this.getProperty());
            if (this.myN <= 0) {
                throw new ExpectedNumberException("The number of buckets must be a positive integer, but got \"" + this.getProperty() + "\".");
            }
        }
        catch (NumberFormatException e) {
            throw new ExpectedNumberException("The number of buckets must be a positive integer, but got \"" + this.getProperty() + "\".");
        }
    }

    public NtileAnalytic replicate() {
        return new NtileAnalytic(String.valueOf(this.myN));
    }

    public int getNumDependentFunctions() {
        return 2;
    }

    public AnalyticFunction getAnalyticFunction(int index) {
        switch (index) {
            case 0: {
                return new CountAggregator("*");
            }
            case 1: {
                return new CountAggregator("*");
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index);
    }

    public WindowClause getWindowClause(int index) {
        switch (index) {
            case 0: {
                return new WindowClause(WindowClause.Type.ROWS, null, 0);
            }
            case 1: {
                return new WindowClause(WindowClause.Type.RANGE, null, null);
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index);
    }

    public Long terminate() {
        long z;
        long count;
        long y;
        long x;
        long rownum = (Long)this.getValue(0);
        if (rownum <= (x = (y = (count = ((Long)this.getValue(1)).longValue()) % (long)this.myN) * ((z = count / (long)this.myN) + 1L))) {
            return (rownum - 1L) / (z + 1L) + 1L;
        }
        return y + (rownum - 1L - x) / z + 1L;
    }
}

